#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/modified_before_porto_container_start_basic_node.h>

namespace NInfra::NPodAgent {

class TFileModifiedRecursiveBeforePortoContainerStartNode;
using TFileModifiedRecursiveBeforePortoContainerStartNodePtr = TSimpleSharedPtr<TFileModifiedRecursiveBeforePortoContainerStartNode>;

class TFileModifiedRecursiveBeforePortoContainerStartNode : public TModifiedBeforePortoContainerStartBasicNode<TExpected<TList<time_t>, TPosixError> > {
public:
    TFileModifiedRecursiveBeforePortoContainerStartNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPosixWorkerPtr posixWorker
        , const TPortoContainerName& containerName
        , const TString& resourcePath
    )
        : TModifiedBeforePortoContainerStartBasicNode(
            descriptor
            , porto
            , posixWorker
            , containerName
            , resourcePath
        )
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TExpected<TList<time_t>, TPosixError>> GetPosixTimeResult() override final;
    virtual TExpected<time_t, TPosixError> GetModificationTimeFromPosixResult(const TExpected<TList<time_t>, TPosixError>& posixTimeResult) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FILE_MODIFIED_RECURSIVE_BEFORE_PORTO_CONTAINER_START;
};

} // namespace NInfra::NPodAgent
