#include "is_directory_node.h"

namespace NInfra::NPodAgent {

ENodeType TIsDirectoryNode::GetType() const {
    return TIsDirectoryNode::NODE_TYPE;
}

NThreading::TFuture<TPosixCheckResult> TIsDirectoryNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->IsDirectoryAsync(Path_);
}

TTickResult TIsDirectoryNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixCheckResult& result) {
    if (!result) {
        return TNodeError({ToString(result.Error())});
    }

    if (!result.Success()) {
        return TNodeSuccess(ENodeStatus::FAILURE);
    }

    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
