#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

namespace NInfra::NPodAgent {

class TIsDirectoryNode;
using TIsDirectoryNodePtr = TSimpleSharedPtr<TIsDirectoryNode>;

class TIsDirectoryNode : public TPosixBasicNode<TPosixCheckResult> {
public:
    TIsDirectoryNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TString& path
        , TPosixWorkerPtr posix
    )
        : TPosixBasicNode<TPosixCheckResult>(descriptor, posix)
        , Path_(path)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixCheckResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixCheckResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::IS_DIRECTORY;

private:
    const TString Path_;
};

} // namespace NInfra::NPodAgent
