#include "make_directory_node.h"

namespace NInfra::NPodAgent {

ENodeType TMakeDirectoryNode::GetType() const {
    return TMakeDirectoryNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TMakeDirectoryNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->MakeDirectoryRecursiveAsync(Path_);
}

TTickResult TMakeDirectoryNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
