#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TMakeDirectoryNode;
using TMakeDirectoryNodePtr = TSimpleSharedPtr<TMakeDirectoryNode>;

class TMakeDirectoryNode : public TPosixBasicNode<TPosixResult> {
public:
    TMakeDirectoryNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posix
        , const TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& path
    )
        : TPosixBasicNode<TPosixResult>(descriptor, posix)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
        , Path_(path)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TMakeDirectoryNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::MAKE_DIRECTORY;

private:
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;

    const TString Path_;
};

} // namespace NInfra::NPodAgent
