#include "make_hard_link_node.h"

namespace NInfra::NPodAgent {

ENodeType TMakeHardLinkNode::GetType() const {
    return TMakeHardLinkNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TMakeHardLinkNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->MakeHardLinkAsync(ExistingPath_, NewPath_);
}

TTickResult TMakeHardLinkNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
