#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TMakeHardLinkNode;
using TMakeHardLinkNodePtr = TSimpleSharedPtr<TMakeHardLinkNode>;

class TMakeHardLinkNode : public TPosixBasicNode<TPosixResult> {
public:
    TMakeHardLinkNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posix
        , const TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& existingPath
        , const TString& newPath
    )
        : TPosixBasicNode<TPosixResult>(descriptor, posix)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
        , ExistingPath_(existingPath)
        , NewPath_(newPath)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TMakeHardLinkNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::MAKE_HARD_LINK;

private:
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;

    const TString ExistingPath_;
    const TString NewPath_;
};

} // namespace NInfra::NPodAgent
