#include "make_log_file_node.h"

namespace NInfra::NPodAgent {

ENodeType TMakeLogFileNode::GetType() const {
    return TMakeLogFileNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TMakeLogFileNode::PosixCall(TTickContextPtr /* context */) {
    return Posix_->MakeFileAsync(Path_);
}

TTickResult TMakeLogFileNode::ProcessPosixResult(TTickContextPtr /* context */, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        ContainerStatusRepository_->UpdateContainerFailReason(Container_, ToString(result.Error()));
        ContainerStatusRepository_->IncrementContainerSystemFailureCounter(Container_);

        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
