#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TMakeLogFileNode;
using TMakeLogFileNodePtr = TSimpleSharedPtr<TMakeLogFileNode>;

class TMakeLogFileNode : public TPosixBasicNode<TPosixResult> {
public:
    TMakeLogFileNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posix
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TString& path
    )
        : TPosixBasicNode<TPosixResult>(descriptor, posix)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
        , Path_(path)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TMakeLogFileNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::MAKE_LOG_FILE;

private:
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;

    const TString Path_;
};

} // namespace NInfra::NPodAgent
