#include "make_sym_link_node.h"

namespace NInfra::NPodAgent {

ENodeType TMakeSymLinkNode::GetType() const {
    return TMakeSymLinkNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TMakeSymLinkNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->MakeSymLinkAsync(ExistingPath_, NewPath_);
}

TTickResult TMakeSymLinkNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
