#include "remove_file_node.h"

namespace NInfra::NPodAgent {

ENodeType TRemoveFileNode::GetType() const {
    return TRemoveFileNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TRemoveFileNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->RemoveFileAsync(Path_);
}

TTickResult TRemoveFileNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
