#include "remove_file_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent::NTestRemoveFileNode {

static TLogger logger({});

void CreateFile(const TString& path){
    TOFStream flag(path);
    flag.Flush();
    flag.Finish();
}

Y_UNIT_TEST_SUITE(RemoveFileNodeSuite) {

Y_UNIT_TEST(RemoveFileSuccess) {
    CreateFile("flag");
    UNIT_ASSERT(NFs::Exists("flag"));

    TAtomicSharedPtr<IThreadPool> pool = new TFakeThreadPool;
    TAtomicSharedPtr<TPosixWorker> posixWorker = new TPosixWorker(pool);

    TRemoveFileNodePtr node = new TRemoveFileNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , "flag"
        , posixWorker
    );

    auto tickResult = node->Tick(MockTickContext(logger));
    UNIT_ASSERT((bool)tickResult);
    UNIT_ASSERT(!NFs::Exists("flag"));
}

Y_UNIT_TEST(RemoveFileFailure) {
    struct TMyPosixFailingClient : public TPosixWorker {
        TMyPosixFailingClient() : TPosixWorker(nullptr) {}

        NThreading::TFuture<TPosixResult> RemoveFileAsync(const TString& path) override {
            ++Calls;
            LastPath = path;

            auto result = NThreading::NewPromise<TPosixResult>();
            result.SetValue(TPosixError{-1, "RemoveFileAsync"});

            return result;
        }

        size_t Calls = 0;
        TString LastPath = "";
    };

    TPosixWorkerPtr posixWorker = new TMyPosixFailingClient();
    TString path = "flag";

    TRemoveFileNodePtr node = new TRemoveFileNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , path
        , posixWorker
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Success().Message, "RemoveFileAsync");
    UNIT_ASSERT_EQUAL(1, ((TMyPosixFailingClient*)posixWorker.Get())->Calls);
    UNIT_ASSERT_EQUAL(path, ((TMyPosixFailingClient*)posixWorker.Get())->LastPath);
}

}

} // namespace NInfra::NPodAgent::NTestRemoveFileNode
