#include "remove_recursive_node.h"

namespace NInfra::NPodAgent {

ENodeType TRemoveRecursiveNode::GetType() const {
    return TRemoveRecursiveNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TRemoveRecursiveNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->RemoveRecursiveAsync(Path_);
}

TTickResult TRemoveRecursiveNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
