#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

namespace NInfra::NPodAgent {

class TRemoveRecursiveNode;
using TRemoveRecursiveNodePtr = TSimpleSharedPtr<TRemoveRecursiveNode>;

class TRemoveRecursiveNode : public TPosixBasicNode<TPosixResult> {
public:
    TRemoveRecursiveNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TString& path
        , TPosixWorkerPtr posix
    )
        : TPosixBasicNode<TPosixResult>(descriptor, posix)
        , Path_(path)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::REMOVE_RECURSIVE;

private:
    const TString Path_;
};

} // namespace NInfra::NPodAgent
