#include "remove_recursive_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/system/fs.h>

namespace NInfra::NPodAgent::NTestRemoveRecursiveNode {

static TLogger logger({});

Y_UNIT_TEST_SUITE(RemoveRecursiveNodeSuite) {

Y_UNIT_TEST(RemoveRecursiveSuccess) {
    NFs::MakeDirectory("directory");
    UNIT_ASSERT(NFs::Exists("directory"));

    TAtomicSharedPtr<IThreadPool> pool = new TFakeThreadPool;
    TAtomicSharedPtr<TPosixWorker> posixWorker = new TPosixWorker(pool);

    TRemoveRecursiveNodePtr node = new TRemoveRecursiveNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , "directory"
        , posixWorker
    );

    auto tickResult = node->Tick(MockTickContext(logger));
    UNIT_ASSERT((bool)tickResult);
    UNIT_ASSERT(!NFs::Exists("directory"));
}

Y_UNIT_TEST(RemoveRecursiveFailure) {
    struct TMyPosixFailingClient : public TPosixWorker {
        TMyPosixFailingClient() : TPosixWorker(nullptr) {}

        NThreading::TFuture<TPosixResult> RemoveRecursiveAsync(const TString& path) override {
            ++Calls;
            LastPath = path;

            auto result = NThreading::NewPromise<TPosixResult>();
            result.SetValue(TPosixError{-1, "RemoveRecursiveAsync"});

            return result;
        }

        size_t Calls = 0;
        TString LastPath = "";
    };

    TPosixWorkerPtr posixWorker = new TMyPosixFailingClient();
    TString path = "directory";

    TRemoveRecursiveNodePtr node = new TRemoveRecursiveNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , path
        , posixWorker
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Success().Message, "RemoveRecursiveAsync");
    UNIT_ASSERT_EQUAL(1, ((TMyPosixFailingClient*)posixWorker.Get())->Calls);
    UNIT_ASSERT_EQUAL(path, ((TMyPosixFailingClient*)posixWorker.Get())->LastPath);
}

}

} // namespace NInfra::NPodAgent::NTestRemoveRecursiveNode
