#include "set_file_access_mode_recursive_node.h"

namespace NInfra::NPodAgent {

ENodeType TSetFileAccessModeRecursiveNode::GetType() const {
    return TSetFileAccessModeRecursiveNode::NODE_TYPE;
}

NThreading::TFuture<TPosixResult> TSetFileAccessModeRecursiveNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->SetFileModeRecursiveAsync(Path_, Mode_);
}

TTickResult TSetFileAccessModeRecursiveNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixResult& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
    }
}

} // namespace NInfra::NPodAgent
