#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TSetFileAccessModeRecursiveNode;
using TSetFileAccessModeRecursiveNodePtr = TSimpleSharedPtr<TSetFileAccessModeRecursiveNode>;

class TSetFileAccessModeRecursiveNode : public TPosixBasicNode<TPosixResult> {
public:
    TSetFileAccessModeRecursiveNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posixWorker
        , const TString& path
        , const EFileAccessMode mode
        , const TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
    )
        : TPosixBasicNode<TPosixResult>(descriptor, posixWorker)
        , Path_(path)
        , Mode_(mode)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::SET_FILE_ACCESS_MODE_RECURSIVE;

private:
    const TString Path_;
    const EFileAccessMode Mode_;
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;

};

} // namespace NInfra::NPodAgent
