#include "capture_unix_signal_status_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/common.h>

#include <infra/pod_agent/libs/common/common.h>

#include <infra/pod_agent/libs/system_logs_sender/system_logs_session_parameters.h>

namespace NInfra::NPodAgent {

ENodeType TCaptureUnixSignalStatusNode::GetType() const {
    return TCaptureUnixSignalStatusNode::NODE_TYPE;
}

TExpected<NThreading::TFuture<TExpected<void, TSystemLogsSenderError>>, TTickResult> TCaptureUnixSignalStatusNode::CaptureStatus(TTickContextPtr context) {
    API::TUnixSignalStatus::TAttemptFeedback attemptFeedback = WorkloadStatusRepository_->CaptureStopUnixSignalStatus(WorkloadId_);
    NLogEvent::TUnixSignalAttemptFeedback logEvent = CreateLogEvent(attemptFeedback);

    context.Get()->LogFrame.Get()->LogEvent(logEvent);

    TString systemLogsMessage = SystemLogsMessage(logEvent);

    return SystemLogsSender_->SendMessage(WorkloadId_, systemLogsMessage);
}

NLogEvent::TUnixSignalAttemptFeedback TCaptureUnixSignalStatusNode::CreateLogEvent(const API::TUnixSignalStatus::TAttemptFeedback& feedback) {
    NLogEvent::TUnixSignalAttemptFeedback logEvent;
    
    ui64 sendTimeInMicroSeconds = TimestampToMicros(feedback.send_time());

    logEvent.set_id(WorkloadId_);
    logEvent.set_object_type(NLogEvent::EPodAgentObjectType::WORKLOAD);
    logEvent.set_fail_reason(feedback.fail_reason());
    logEvent.set_state((NLogEvent::TUnixSignalAttemptFeedback::EUnixSignalState)feedback.state());
    logEvent.set_send_time(sendTimeInMicroSeconds);

    return logEvent;
}

TString TCaptureUnixSignalStatusNode::SystemLogsMessage(const NLogEvent::TUnixSignalAttemptFeedback& logEvent) {
    NLogEvent::TUnixSignalHookSystemLogsEvent systemLogsEvent;

    systemLogsEvent.SetloggerName(TSystemLogsSessionParameters::DEPLOY_LOGGER_NAME_VALUE);
    systemLogsEvent.set_message(LogEventToMessage<NLogEvent::TUnixSignalAttemptFeedback>(logEvent));
    systemLogsEvent.set_workload(WorkloadId_);
    systemLogsEvent.set_state(logEvent.state());
    systemLogsEvent.set_fail_reason(logEvent.fail_reason());
    
    return LogEventToMessage<NLogEvent::TUnixSignalHookSystemLogsEvent>(systemLogsEvent);
}

TTickResult TCaptureUnixSignalStatusNode::ProcessResult(TTickContextPtr /*context*/, TExpected<void, TSystemLogsSenderError>& result) {
    if (!bool(result)) {
        return TNodeError({ToString(result.Error())});
    }
 
    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
