#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/capture_status_basic_node.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TCaptureUnixSignalStatusNode;
using TCaptureUnixSignalStatusNodePtr = TSimpleSharedPtr<TCaptureUnixSignalStatusNode>;

class TCaptureUnixSignalStatusNode : public TCaptureStatusBasicNode<TExpected<void, TSystemLogsSenderError>> {
public:
    TCaptureUnixSignalStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , ISystemLogsSenderPtr systemLogsSender
        , const TString& workloadId
    )
        : TCaptureStatusBasicNode(descriptor, systemLogsSender)
        , WorkloadStatusRepository_(workloadStatusRepository)
        , WorkloadId_(workloadId)
        
    {
        Y_ENSURE(WorkloadStatusRepository_, "WorkloadStatusRepository not defined for TCaptureUnixSignalStatusNode");
    }

    virtual ENodeType GetType() const override final;

//public for tests
public:
    NLogEvent::TUnixSignalAttemptFeedback CreateLogEvent(const API::TUnixSignalStatus::TAttemptFeedback& feedback);
    TString SystemLogsMessage(const NLogEvent::TUnixSignalAttemptFeedback& logEvent);

private:
    virtual TExpected<NThreading::TFuture<TExpected<void, TSystemLogsSenderError>>, TTickResult> CaptureStatus(TTickContextPtr context) override final;
    virtual TTickResult ProcessResult(TTickContextPtr context, TExpected<void, TSystemLogsSenderError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CAPTURE_UNIX_SIGNAL_STATUS;

private:
    TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
    TString WorkloadId_;
};

} // namespace NInfra::NPodAgent
