#include "check_unix_signal_retries_node.h"

namespace NInfra::NPodAgent {

ENodeType TCheckUnixSignalRetriesNode::GetType() const {
    return TCheckUnixSignalRetriesNode::NODE_TYPE;
}

TTickResult TCheckUnixSignalRetriesNode::TickImpl(TTickContextPtr) {
    if (MaxTries_ == 0) {
        return TNodeError{"Check http hook retries node must be unreachable when MaxTries is zero"};
    }

    ui32 tries =
        WorkloadStatusRepository_->GetStopUnixSignalSuccessCounter(WorkloadId_)
        + WorkloadStatusRepository_->GetStopUnixSignalErrorCounter(WorkloadId_)
    ;

    if (tries < MaxTries_) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Workload '" << WorkloadId_ << "' exceeded stop tries limit: " << MaxTries_);
    }
}

} // namespace NInfra::NPodAgent
