#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TCheckUnixSignalRetriesNode;
using TCheckUnixSignalRetriesNodePtr = TSimpleSharedPtr<TCheckUnixSignalRetriesNode>;

class TCheckUnixSignalRetriesNode : public TWorkloadBasicNode  {
public:
    TCheckUnixSignalRetriesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , ui32 maxTries
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , MaxTries_(maxTries)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CHECK_UNIX_SIGNAL_RETRIES;

private:
    const ui32 MaxTries_;
};

} // namespace NInfra::NPodAgent
