#include "check_unix_signal_retries_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestCheckUnixSignalRetriesNode  {

static TLogger logger({});

TCheckUnixSignalRetriesNodePtr GetCheckUnixSignalRetriesNode(
    TWorkloadStatusRepositoryPtr statusRepository
    , const TString& workloadId
    , ui32 maxTries
) {
    if (statusRepository) {
        statusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(workloadId));
    }

    return new TCheckUnixSignalRetriesNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , statusRepository
        , workloadId
        , maxTries
    );
}

Y_UNIT_TEST_SUITE(CheckUnixSignalRetriesNode) {

Y_UNIT_TEST(TestSuccess) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    const TString workloadId = "my_workload";
    auto node = GetCheckUnixSignalRetriesNode(statusRepository, workloadId, 2);
    statusRepository->IncrementStopUnixSignalSuccessCounter(workloadId);
    auto res = node->Tick(MockTickContext(logger));

    UNIT_ASSERT((bool)res);
    UNIT_ASSERT_EQUAL(res.Success().Status, ENodeStatus::SUCCESS);
}

Y_UNIT_TEST(TestFailure) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    const TString workloadId = "my_workload";
    auto node = GetCheckUnixSignalRetriesNode(statusRepository, workloadId, 2);
    statusRepository->IncrementStopUnixSignalSuccessCounter(workloadId);
    statusRepository->IncrementStopUnixSignalErrorCounter(workloadId);
    auto res = node->Tick(MockTickContext(logger));

    UNIT_ASSERT((bool)res);
    UNIT_ASSERT_EQUAL(res.Success().Status, ENodeStatus::FAILURE);
    UNIT_ASSERT_STRING_CONTAINS(TStringBuilder() << "Workload '" << workloadId << "' exceeded stop tries limit: 2", res.Success().Message);
}

Y_UNIT_TEST(TestWorkloadStatusRepositoryNotDefined) {
    UNIT_ASSERT_EXCEPTION_CONTAINS(
        GetCheckUnixSignalRetriesNode(
            nullptr
            , "my_workload"
            , 1
        )
        , yexception
        , "WorkloadStatusRepository not defined"
    );
}

Y_UNIT_TEST(TestStatusMaxTriesIsZero) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    auto node = GetCheckUnixSignalRetriesNode(statusRepository, "my_workload", 0);
    auto res = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_STRING_CONTAINS(res.Error().Message, "MaxTries is zero");
}

}

} // namespace NInfra::NPodAgent::NTestCheckUnixSignalRetriesNode
