#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackUnixSignalStateNode;
using TFeedbackUnixSignalStateNodePtr = TSimpleSharedPtr<TFeedbackUnixSignalStateNode>;

class TFeedbackUnixSignalStateNode : public TWorkloadBasicNode {
public:
    TFeedbackUnixSignalStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , const API::EUnixSignalState state
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , State_(state)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_UNIX_SIGNAL_STATE;

private:
    const API::EUnixSignalState State_;
};

} // namespace NInfra::NPodAgent
