#include "feedback_unix_signal_state_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackUnixSignalStateNode {

Y_UNIT_TEST_SUITE(FeedbackUnixSignalStateNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestUpdateState) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));

    const API::EUnixSignalState state = API::EUnixSignalState::EUnixSignalState_WAITING_RESTART;
    TFeedbackUnixSignalStateNodePtr node = new TFeedbackUnixSignalStateNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
        , state
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());

    auto status = GetStopUnixSignalStatus(holder->GetObjectStatus(id));
    UNIT_ASSERT_EQUAL(state, status.current().state());
}

Y_UNIT_TEST(TestWithUndefinedWorkloadStatusRepository) {
    const API::EUnixSignalState state = API::EUnixSignalState::EUnixSignalState_WAITING_RESTART;

    UNIT_ASSERT_EXCEPTION_CONTAINS(
        TFeedbackUnixSignalStateNode(
            TBasicTreeNodeDescriptor{1, "title"}
            , nullptr
            , "my_workload"
            , state
        )
        , yexception
        , "WorkloadStatusRepository not defined"
    );
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackUnixSignalStateNode
