#include "porto_kill_with_unix_signal_feedback_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoKillWithUnixSignalFeedbackNode::GetType() const {
    return TPortoKillWithUnixSignalFeedbackNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoKillWithUnixSignalFeedbackNode::PortoCall(TTickContextPtr /* context */) {
    WorkloadStatusRepository_->UpdateStopUnixSignalSendTime(WorkloadId_, TInstant::Now());
    return Porto_->Kill(ContainerName_, Signal_);
}

TTickResult TPortoKillWithUnixSignalFeedbackNode::ProcessPortoResult(TTickContextPtr /* context */, TExpected<void, TPortoError>& result) {
    if (result) {
        WorkloadStatusRepository_->UpdateStopUnixSignalState(WorkloadId_, API::EUnixSignalState_SUCCESS);

        WorkloadStatusRepository_->UpdateStopUnixSignalConsecutiveFailuresAndSuccessesCounter(WorkloadId_, true);
        WorkloadStatusRepository_->IncrementStopUnixSignalSuccessCounter(WorkloadId_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        WorkloadStatusRepository_->UpdateStopUnixSignalState(WorkloadId_, API::EUnixSignalState_FAILURE);
        WorkloadStatusRepository_->UpdateStopUnixSignalFailReason(WorkloadId_, ToString(result.Error()));

        WorkloadStatusRepository_->UpdateStopUnixSignalConsecutiveFailuresAndSuccessesCounter(WorkloadId_, false);
        WorkloadStatusRepository_->IncrementStopUnixSignalErrorCounter(WorkloadId_);

        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::ContainerDoesNotExist
            || result.Error().Code == EPortoError::InvalidState
            // Bad signal value
            || result.Error().Code == EPortoError::InvalidValue
            // This error is interpreted as Unknown, we can get the real reason only from message
            || (result.Error().Code == EPortoError::Unknown && result.Error().Message.Contains("No such process"))
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
