#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TPortoKillWithUnixSignalFeedbackNode;
using TPortoKillWithUnixSignalFeedbackNodePtr = TSimpleSharedPtr<TPortoKillWithUnixSignalFeedbackNode>;

class TPortoKillWithUnixSignalFeedbackNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoKillWithUnixSignalFeedbackNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , const TPortoContainerName& containerName
        , i32 signal
    )
        : TPortoBasicNode(descriptor, porto)
        , WorkloadStatusRepository_(workloadStatusRepository)
        , WorkloadId_(workloadId)
        , ContainerName_(containerName)
        , Signal_(signal)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_KILL_WITH_UNIX_SIGNAL_FEEDBACK;

private:
    const TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
    const TString WorkloadId_;

    const TPortoContainerName ContainerName_;
    const i32 Signal_;
};

} // namespace NInfra::NPodAgent
