#include "unix_signal_send_time_expired_with_backoff_node.h"

namespace NInfra::NPodAgent {

ENodeType TUnixSignalSendTimeExpiredWithBackoffNode::GetType() const {
    return TUnixSignalSendTimeExpiredWithBackoffNode::NODE_TYPE;
}

TTickResult TUnixSignalSendTimeExpiredWithBackoffNode::TickImpl(TTickContextPtr context) {
    TInstant startTime = WorkloadStatusRepository_->GetStopUnixSignalSendTime(WorkloadId_);
    ui32 consecutiveTries = WorkloadStatusRepository_->GetStopUnixSignalConsecutiveSuccessesCounter(WorkloadId_);

    // step = Max(0, ConsecutiveSuccessesCounter - 1)
    ui32 step = Max((ui32)1, consecutiveTries) - 1;
    return BackoffCalcer_.CheckAndUpdateContext(startTime, step, context);
}

} // namespace NInfra::NPodAgent
