#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/time_expired_with_backoff_calcer.h>

namespace NInfra::NPodAgent {

class TUnixSignalSendTimeExpiredWithBackoffNode;
using TUnixSignalSendTimeExpiredWithBackoffNodePtr = TSimpleSharedPtr<TUnixSignalSendTimeExpiredWithBackoffNode>;

class TUnixSignalSendTimeExpiredWithBackoffNode : public TWorkloadBasicNode {
public:
    TUnixSignalSendTimeExpiredWithBackoffNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , TDuration restartPeriodScale
        , ui64 restartPeriodBackOff
        , TDuration maxRestartPeriod
        , TDuration minRestartPeriod
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , BackoffCalcer_(
            restartPeriodScale
            , restartPeriodBackOff
            , maxRestartPeriod
            , minRestartPeriod
        )
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::UNIX_SIGNAL_SEND_TIME_EXPIRED_WITH_BACKOFF;

private:
    const TTimeExpiredWithBackoffCalcer BackoffCalcer_;
};

} // namespace NInfra::NPodAgent
