#pragma once

#include <infra/pod_agent/libs/behaviour/bt/core/tree.h>

#include <library/cpp/colorizer/colors.h>

#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/generic/list.h>
#include <util/generic/hash_set.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

class TConsoleRenderer;

using TConsoleRendererPtr = TSimpleSharedPtr<TConsoleRenderer>;

class TConsoleRenderer {
public:
    TConsoleRenderer(bool useColors)
        : UseColors_(useColors)
    {}

    TString Render(TTreeConstPtr tree, bool all = false);
    TString RenderAll(TTreeConstPtr tree);

private:
    void DFSRender(TBasicTreeNodePtr node, i32 depth, const THashSet<ui64>& traced, bool renderAll, TStringBuilder& result);

    TString RenderHeader() const;

    TString NodeResult(const TTickResult& result);

    TString Red(TStringBuf text);

    TString Green(TStringBuf text);

    TString Blue(TStringBuf text);

    TString Purple(TStringBuf text);

    TString BoldWhite(TStringBuf text);

    TString BoldYellow(TStringBuf text);

private:
    static inline const TString SINGLE_INDENT = "  ";

private:
    NColorizer::TColors Colors_;
    bool UseColors_;
};

} // namespace NInfra::NPodAgent
