#include "console_renderer.h"

#include "create_test_tree.h"

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>

namespace NInfra::NPodAgent::NConsoleRenderTest {

Y_UNIT_TEST_SUITE(ConsoleRenderTestSuite) {

Y_UNIT_TEST(RenderTree) {
    TTreePtr tree = CreateAndTickTree();
    auto renderer = MakeSimpleShared<TConsoleRenderer>(false);
    TFileInput input(ArcadiaSourceRoot() +  "/infra/pod_agent/libs/behaviour/bt/render/ut/behavior3_render.txt");
    UNIT_ASSERT_VALUES_EQUAL(input.ReadAll(), renderer->Render(tree));
}

Y_UNIT_TEST(RenderTreeWithColors) {
    TTreePtr tree = CreateAndTickTree();
    auto renderer = MakeSimpleShared<TConsoleRenderer>(true);
    TFileInput input(ArcadiaSourceRoot() +  "/infra/pod_agent/libs/behaviour/bt/render/ut/behavior3_render.txt");
    UNIT_ASSERT_VALUES_EQUAL(input.ReadAll(), renderer->Render(tree));
}

Y_UNIT_TEST(RenderAllTree) {
    TTreePtr tree = CreateAndTickTree();
    auto renderer = MakeSimpleShared<TConsoleRenderer>(false);
    TFileInput input(ArcadiaSourceRoot() +  "/infra/pod_agent/libs/behaviour/bt/render/ut/behavior3_render_all.txt");
    UNIT_ASSERT_VALUES_EQUAL(input.ReadAll(), renderer->RenderAll(tree));
}

}

} // namespace NInfra::NPodAgent::NConsoleRenderTest
