#include "create_test_tree.h"

#include <infra/pod_agent/libs/behaviour/bt/template_tree/template_tree.h>
#include <infra/pod_agent/libs/behaviour/loaders/behavior3_editor_json_reader.h>

#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <util/stream/file.h>

namespace NInfra::NPodAgent {

namespace {

static TLogger logger({});

} // namespace

TTreePtr CreateAndTickTree() {
    TBehavior3 protoTree = CreateTestTemplateBehaviorTree();
    TLayerStatusRepositoryPtr statusRepository = new TLayerStatusRepository();
    statusRepository->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple("my_layer", "my_layer_download_hash"));
    TTreePtr tree = new TTree(logger, "tree", TBehavior3EditorJsonReader(protoTree).WithLayerStatusRepository(statusRepository).BuildRootNode());
    auto tick = tree->Tick();
    return tree;
}

} // namespace NInfra::NPodAgent
