#pragma once

#include <infra/pod_agent/libs/behaviour/bt/core/tree.h>

#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class TProtoRenderer;
using TProtoRendererPtr = TSimpleSharedPtr<TProtoRenderer>;

class TProtoRenderer {
public:
    TProtoRenderer()
    {}

    NLogEvent::TBehaviourTreeTickV2 Render(TTreeConstPtr tree);

private:
    void DFSRender(
        TBasicTreeNodePtr node
        , const THashSet<ui64>& traced
        , NLogEvent::TBehaviourTreeTickV2::TNodeTick* result
    );

    static NLogEvent::TBehaviourTreeTickV2::ENodeStatus ConvertNodeStatus(ENodeStatus nodeStatus);
    static NLogEvent::TBehaviourTreeTickV2::ENodeType ConvertNodeType(ENodeType nodeType);
};

} // namespace NInfra::NPodAgent
