#include "proto_renderer.h"

#include "create_test_tree.h"

#include <library/cpp/protobuf/json/proto2json.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>

namespace NInfra::NPodAgent::NProtoRenderTest {

Y_UNIT_TEST_SUITE(ProtoRenderTestSuite) {

Y_UNIT_TEST(RenderTree) {
    TTreePtr tree = CreateAndTickTree();
    TFileInput input(ArcadiaSourceRoot() +  "/infra/pod_agent/libs/behaviour/bt/render/ut/behavior3_render_proto.txt");
    UNIT_ASSERT_VALUES_EQUAL(input.ReadAll(), NProtobufJson::Proto2Json(TProtoRenderer().Render(tree)));
}

}

} // namespace NInfra::NPodAgent::NProtoRenderTest
