#include "template_tree.h"

namespace NInfra::NPodAgent {

TBehavior3 CreateTestTemplateBehaviorTree() {
    TBehavior3 templateTree;
    {
        templateTree.set_title("A behavior tree");
        templateTree.set_root("1");
        TBehavior3Node root;
        {
            root.set_id("1");
            root.set_name("MemSelector");
            root.set_title("Root:A behavior tree:");
            root.add_children("2");
            root.add_children("4");
            root.add_children("5");
        }
        (*templateTree.mutable_nodes())["1"] = root;

        TBehavior3Node inv;
        {
            inv.set_id("2");
            inv.set_name("Inverter");
            inv.set_title("");
            inv.set_child("3");
        }
        (*templateTree.mutable_nodes())["2"] = inv;

        TBehavior3Node leaf_0;
        {
            leaf_0.set_id("3");
            leaf_0.set_name("FeedbackObjectState");
            leaf_0.set_title("layer, ELayerState_REMOVED");
            google::protobuf::Value val;
            val.set_string_value("my_layer_download_hash"); (*leaf_0.mutable_properties())["object_id_or_hash"] = val;
            val.set_string_value("ELayerState_REMOVED"); (*leaf_0.mutable_properties())["state"] = val;
            val.set_string_value("layer"); (*leaf_0.mutable_properties())["object_type"] = val;
        }
        (*templateTree.mutable_nodes())["3"] = leaf_0;

        TBehavior3Node leaf_1;
        {
            leaf_1.set_id("4");
            leaf_1.set_name("FeedbackObjectState");
            leaf_1.set_title("layer, ELayerState_DOWNLOADING");
            google::protobuf::Value val;
            val.set_string_value("my_layer_download_hash"); (*leaf_1.mutable_properties())["object_id_or_hash"] = val;
            val.set_string_value("ELayerState_DOWNLOADING"); (*leaf_1.mutable_properties())["state"] = val;
            val.set_string_value("layer"); (*leaf_1.mutable_properties())["object_type"] = val;
        }
        (*templateTree.mutable_nodes())["4"] = leaf_1;

        TBehavior3Node leaf_2;
        {
            leaf_2.set_id("5");
            leaf_2.set_name("FeedbackObjectState");
            leaf_2.set_title("layer, ELayerState_VERIFYING");
            google::protobuf::Value val;
            val.set_string_value("my_layer_download_hash"); (*leaf_2.mutable_properties())["object_id_or_hash"] = val;
            val.set_string_value("ELayerState_VERIFYING"); (*leaf_2.mutable_properties())["state"] = val;
            val.set_string_value("layer"); (*leaf_2.mutable_properties())["object_type"] = val;
        }
        (*templateTree.mutable_nodes())["5"] = leaf_2;
    }

    return templateTree;
}

} // namespace NInfra::NPodAgent
