#include "behavior3_editor_json_reader.h"

#include <infra/pod_agent/libs/behaviour/loaders/behavior3_template_resolver.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/mock_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/variable_is_set_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/case_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/inverter_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/mem_selector_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/mem_sequence_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/static_switch_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/switch_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/timed_cache_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/composite/try_lock_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/container/capture_container_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/check_container_retries_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/container_consecutive_tries_reached_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/container_start_time_expired_with_backoff_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_death_time_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_fail_reason_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_owner_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_start_time_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_stderr_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/container/feedback_container_stdout_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_check_failed_message_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_download_attempt_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_download_complete_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_failed_message_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_ip_address_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/feedback_object/feedback_object_verify_attempt_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/layer_keep_source_file_after_import_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/set_workload_was_destroyed_by_hook_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/static_resource_state_matches_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/workload_clear_destroy_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/workload_clear_stop_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/workload_should_be_destroyed_by_hook_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/internal_state/workload_target_active_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/ip_operations/add_ip_address_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/network/capture_network_hook_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/check_http_hook_retries_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/feedback_http_hook_fail_reason_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/feedback_network_hook_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_check_and_add_request_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_get_and_remove_request_response_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_get_request_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_hook_consecutive_tries_reached_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_hook_start_time_expired_with_backoff_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/network/network_remove_request_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_active_download_containers_limit_reached_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_active_verify_containers_limit_reached_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_add_properties_to_container_fail_reason_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_add_properties_to_object_failed_message_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_clean_linked_volumes_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_clean_old_containers_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_container_exists_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_container_private_matches_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_container_property_matches_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_container_time_expired_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_container_tree_hash_matches_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_create_recursive_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_create_volume_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_destroy_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_get_and_check_properties_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_get_and_check_volume_properties_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_get_container_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_get_download_progress_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_get_private_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_import_layer_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_kill_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_layer_exists_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_layers_ready_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_link_volume_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_remove_layer_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_remove_storage_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_set_container_private_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_set_layer_private_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_set_properties_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_set_property_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_start_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_static_resource_verify_container_time_expired_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_stop_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_storage_private_matches_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_storage_exists_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_unlink_volume_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_volume_exists_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/porto/porto_volume_is_link_of_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/check_same_inode_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/file_exist_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/file_modified_before_porto_container_start_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/file_modified_before_porto_volume_build_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/file_modified_recursive_before_porto_container_start_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/is_directory_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/make_directory_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/make_hard_link_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/make_log_file_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/make_sym_link_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/remove_file_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/remove_recursive_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/posix/set_file_access_mode_recursive_node.h>

#include <infra/pod_agent/libs/behaviour/bt/nodes/unix_signal/capture_unix_signal_status_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/unix_signal/check_unix_signal_retries_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/unix_signal/feedback_unix_signal_state_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/unix_signal/porto_kill_with_unix_signal_feedback_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/unix_signal/unix_signal_send_time_expired_with_backoff_node.h>

#include <infra/pod_agent/libs/pod_agent/trees_generators/types/trees_generators_types.h>

#include <util/digest/numeric.h>
#include <util/string/type.h>

namespace NInfra::NPodAgent {

#define NODE_CREATOR_FUNCTION(NodeType) \
    NodeType \
    , []( \
        const ui64 nodeId \
        , const TBehavior3Node& nodeInfo \
        , const TBehavior3EditorJsonReader::TBehavior3Context& context \
        , const TBehavior3& /* tree */ \
    ) -> TBasicTreeNodePtr \

#define NODE_CREATOR_FUNCTION_NO_CONTEXT(NodeType) \
    NodeType \
    , []( \
        const ui64 nodeId \
        , const TBehavior3Node& nodeInfo \
        , const TBehavior3EditorJsonReader::TBehavior3Context& /* context */ \
        , const TBehavior3& /* tree */ \
    ) -> TBasicTreeNodePtr \

#define NODE_CREATOR_FUNCTION_WITH_TREE(NodeType) \
    NodeType \
    , []( \
        const ui64 nodeId \
        , const TBehavior3Node& nodeInfo \
        , const TBehavior3EditorJsonReader::TBehavior3Context& context \
        , const TBehavior3& tree \
    ) -> TBasicTreeNodePtr \

THashMap<
    ENodeType
    , std::function<
        TBasicTreeNodePtr(
            const ui64 nodeId
            , const TBehavior3Node& nodeInfo
            , const TBehavior3EditorJsonReader::TBehavior3Context& context
            , const TBehavior3& tree
        )
    >
> TBehavior3EditorJsonReader::NODE_CREATORS = {
    {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::UNKNOWN) {
            Y_UNUSED(nodeId);
            Y_UNUSED(nodeInfo);
            ythrow yexception() << "You can't create UNKNOWN nodes";
        }
    }

    // Special
    , {
        NODE_CREATOR_FUNCTION_WITH_TREE(ENodeType::MEM_SEQUENCE_GENERATOR) {
            Y_ENSURE(nodeInfo.Getchildren().empty(), nodeInfo.Getname() << " should have one child");
            Y_ENSURE(nodeInfo.has_child(), nodeInfo.Getname() << " should have one child");
            // Node properties are GNRT map for subtree
            TVector<TMap<TString, TString>> replaceMaps;
            for (auto& it : nodeInfo.Getproperties()) {
                TVector<TString> parts = TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TString(it.second.string_value()));
                if (replaceMaps.size()) {
                    Y_ENSURE(replaceMaps.size() == parts.size(), "bad property " << it.first << " value " << it.second.string_value() << " for " << nodeInfo.Getname() << " node:"
                        << " expected " << replaceMaps.size() << " parts"
                        << ", but only got " << parts.size()
                    );
                } else {
                    replaceMaps.resize(parts.size());
                }
                for (size_t i = 0; i < parts.size(); ++i) {
                    replaceMaps[i][it.first] = parts[i];
                }
            }
            if (replaceMaps.empty()) {
                return TMockNodePtr(
                    new TMockNode(
                        {nodeId, nodeInfo.Gettitle()}
                        , TTickResult(ENodeStatus::SUCCESS)
                    )
                );
            }
            TVector<TBasicTreeNodePtr> childrenNodes;
            for (size_t i = 0; i < replaceMaps.size(); ++i) {
                TBehavior3 resolvedTree;
                resolvedTree.CopyFrom(tree);
                TBehavior3TemplateResolver().ResolveNode(resolvedTree, nodeInfo.Getchild(), "GNRT", replaceMaps[i]);
                ui64 parentId = CombineHashes(nodeId, i);
                childrenNodes.push_back(TBehavior3EditorJsonReader(resolvedTree, parentId)
                    .WithContext(context)
                    .BuildNode(nodeInfo.Getchild())
                );
            }
            return TMemSequenceNodePtr(
                new TMemSequenceNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , childrenNodes
                )
            );
        }
    }

    // Base
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::ERROR) {
            return TMockNodePtr(
                new TMockNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TNodeError{ExtractStringValue(nodeInfo, "message")}
                    , ENodeType::ERROR
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::FAILER) {
            return TMockNodePtr(
                new TMockNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TNodeSuccess{ENodeStatus::FAILURE, ExtractStringValue(nodeInfo, "message")}
                    , ENodeType::FAILER
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::MOCK) {
            Y_UNUSED(nodeId);
            Y_UNUSED(nodeInfo);
            ythrow yexception() << "You can't create MOCK nodes in loader. This nodes only for unit tests and fake trees.";
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::SUCCEEDER) {
            return TMockNodePtr(
                new TMockNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TNodeSuccess{ENodeStatus::SUCCESS, ExtractStringValue(nodeInfo, "message")}
                    , ENodeType::SUCCEEDER
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TVariableIsSetNode::NODE_TYPE) {
            return TVariableIsSetNodePtr(
                new TVariableIsSetNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "variable")
                )
            );
        }
    }

    // Composite
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TCaseNode::NODE_TYPE) {
            return TCaseNodePtr(
                new TCaseNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "case")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TInverterNode::NODE_TYPE) {
            return TInverterNodePtr(
                new TInverterNode(
                    {nodeId, nodeInfo.Gettitle()}
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TMemSelectorNode::NODE_TYPE) {
            return TMemSelectorNodePtr(
                new TMemSelectorNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , {}
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TMemSequenceNode::NODE_TYPE) {
            return TMemSequenceNodePtr(
                new TMemSequenceNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , {}
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::STATIC_SWITCH /* Template node */) {
            const TString switchType = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "type");
            if (switchType == "EHookBackend") {
                TString switchValue = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value");
                return TStaticSwitchNodePtr<NStatusRepositoryTypes::EHookBackend>(
                    new TStaticSwitchNode<NStatusRepositoryTypes::EHookBackend>(
                        {nodeId, nodeInfo.Gettitle()}
                        , FromString<NStatusRepositoryTypes::EHookBackend>(switchValue)
                    )
                );
            } else if (switchType == "EResourceVerificationType") {
                TString switchValue = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value");
                return TStaticSwitchNodePtr<NTreesGeneratorsTypes::EResourceVerificationType>(
                    new TStaticSwitchNode<NTreesGeneratorsTypes::EResourceVerificationType>(
                        {nodeId, nodeInfo.Gettitle()}
                        , FromString<NTreesGeneratorsTypes::EResourceVerificationType>(switchValue)
                    )
                );
            } else if (switchType == "EPodAgentModeType") {
                TString switchValue = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value");
                return TStaticSwitchNodePtr<NTreesGeneratorsTypes::EPodAgentModeType>(
                    new TStaticSwitchNode<NTreesGeneratorsTypes::EPodAgentModeType>(
                        {nodeId, nodeInfo.Gettitle()}
                        , FromString<NTreesGeneratorsTypes::EPodAgentModeType>(switchValue)
                    )
                );
            } else {
                ythrow yexception() << "Create StaticSwitchNode for type equal to " << switchType << " not implemented";
            }
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(ENodeType::SWITCH /* Template node */) {
            TString type = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "type");
            if (type == "EConditionReturn") {
                return TSwitchNodePtr<EConditionReturn>(
                    new TSwitchNode<EConditionReturn>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else if (type == "EPortoContainerState") {
                return TSwitchNodePtr<EPortoContainerState>(
                    new TSwitchNode<EPortoContainerState>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else if (type == "EContainerPrivate") {
                return TSwitchNodePtr<EContainerPrivate>(
                    new TSwitchNode<EContainerPrivate>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else if (type == "ELayerPrivate") {
                return TSwitchNodePtr<ELayerPrivate>(
                    new TSwitchNode<ELayerPrivate>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else if (type == "ENetworkClientRequestState") {
                return TSwitchNodePtr<INetworkClient::ERequestState>(
                    new TSwitchNode<INetworkClient::ERequestState>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else if (type == "ETryLockResult") {
                return TSwitchNodePtr<TTryLockNode::ETryLockResult>(
                    new TSwitchNode<TTryLockNode::ETryLockResult>(
                        {nodeId, nodeInfo.Gettitle()}
                    )
                );
            } else {
                ythrow yexception() << "unexpected type '" << type << "' for switch node";
            }
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TTimedCacheNode::NODE_TYPE) {
            return TTimedCacheNodePtr(
                new TTimedCacheNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "timeout_ms"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION_NO_CONTEXT(TTryLockNode::NODE_TYPE) {
            return TTryLockNodePtr(
                new TTryLockNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "owner_id")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "lock_id")
                )
            );
        }
    }

    // Container
    , {
        NODE_CREATOR_FUNCTION(TCaptureContainerStatusNode::NODE_TYPE) {
            return TCaptureContainerStatusNodePtr(
                new TCaptureContainerStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.SystemLogsSender_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TCheckContainerRetriesNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TCheckContainerRetriesNodePtr(
                new TCheckContainerRetriesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "max_tries")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TContainerConsecutiveTriesReachedNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TContainerConsecutiveTriesReachedNodePtr(
                new TContainerConsecutiveTriesReachedNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "count_successes"))
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "tries_threshold")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TContainerStartTimeExpiredNodeWithBackOff::NODE_TYPE) {
            const TDuration minRestart = TDuration::MilliSeconds(ExtractNumberValue(nodeInfo, "min_restart_period_ms"));
            const TDuration maxRestart = TDuration::MilliSeconds(ExtractNumberValue(nodeInfo, "max_restart_period_ms"));
            const TDuration timeScale = TDuration::MilliSeconds(ExtractNumberValue(nodeInfo, "restart_period_scale_ms"));
            const ui64 backOff = ExtractNumberValue(nodeInfo, "restart_period_back_off");

            return TContainerStartTimeExpiredNodeWithBackOffPtr(
                new TContainerStartTimeExpiredNodeWithBackOff(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , minRestart
                    , timeScale
                    , backOff
                    , maxRestart
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerDeathTimeNode::NODE_TYPE) {
           Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackContainerDeathTimeNodePtr(
                new TFeedbackContainerDeathTimeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerFailReasonNode::NODE_TYPE) {
            return TFeedbackContainerFailReasonNodePtr(
                new TFeedbackContainerFailReasonNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "fail_reason")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerOwnerStateNode::NODE_TYPE) {
            return TFeedbackContainerOwnerStateNodePtr(
                new TFeedbackContainerOwnerStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TBehavior3EditorJsonReader::ExtractObjectState(nodeInfo)
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerStartTimeNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackContainerStartTimeNodePtr(
                new TFeedbackContainerStartTimeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerStateNode::NODE_TYPE) {
            const TString state = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "state");
            auto descriptor = API::EContainerState_descriptor();
            auto ptr = descriptor->FindValueByName(state);
            Y_ENSURE(ptr, "Could not cast '" << state << "' to EContainerState at " << nodeInfo.Getname() << " '" << nodeInfo.Gettitle() <<  "' leaf node");

            return TFeedbackContainerStateNodePtr(
                new TFeedbackContainerStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , API::EContainerState(ptr->number())
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerStatusNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackContainerStatusNodePtr(
                new TFeedbackContainerStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerStderrNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackContainerStderrNodePtr(
                new TFeedbackContainerStderrNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );

        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackContainerStdoutNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackContainerStdoutNodePtr(
                new TFeedbackContainerStdoutNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }

    // Feedback object
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectCheckFailedMessageNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TString propertyString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property");
            const EPortoContainerProperty property = FromString(propertyString);

            return TFeedbackObjectCheckFailedMessageNodePtr(
                new TFeedbackObjectCheckFailedMessageNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , property
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "ref")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectDownloadAttemptNode::NODE_TYPE) {
            return TFeedbackObjectDownloadAttemptNodePtr(
                new TFeedbackObjectDownloadAttemptNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectDownloadCompleteNode::NODE_TYPE) {
            return TFeedbackObjectDownloadCompleteNodePtr(
                new TFeedbackObjectDownloadCompleteNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectFailedMessageNode::NODE_TYPE) {
            return TFeedbackObjectFailedMessageNodePtr(
                new TFeedbackObjectFailedMessageNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "failed_message")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectIpAddressNode::NODE_TYPE) {
            return TFeedbackObjectIpAddressNodePtr(
                new TFeedbackObjectIpAddressNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "address")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectStateNode::NODE_TYPE) {
            return TFeedbackObjectStateNodePtr(
                new TFeedbackObjectStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractObjectState(nodeInfo)
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackObjectVerifyAttemptNode::NODE_TYPE) {
            return TFeedbackObjectVerifyAttemptNodePtr(
                new TFeedbackObjectVerifyAttemptNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                )
            );
        }
    }

    // Internal state
    , {
        NODE_CREATOR_FUNCTION(TLayerKeepSourceFileAfterImportNode::NODE_TYPE) {
            Y_ENSURE(context.LayerStatusRepository_, "LayerStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TLayerKeepSourceFileAfterImportNodePtr(
                new TLayerKeepSourceFileAfterImportNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.LayerStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_download_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TSetWorkloadWasDestroyedByHookNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.WorkloadStatusRepositoryInternal_, "WorkloadStatusRepositoryInternal not defined for " << nodeInfo.Getname() << " leaf node");
            return TSetWorkloadWasDestroyedByHookNodePtr(
                new TSetWorkloadWasDestroyedByHookNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , context.WorkloadStatusRepositoryInternal_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TStaticResourceStateMatchesNode::NODE_TYPE) {
            Y_ENSURE(context.StaticResourceStatusRepository_, "StaticResourceStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            const TString state = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "state");
            auto descriptor = API::EStaticResourceState_descriptor();
            auto ptr = descriptor->FindValueByName(state);
            Y_ENSURE(ptr, "Could not cast '" << state << "' to EStaticResourceState at " << nodeInfo.Getname() << " '" << nodeInfo.Gettitle() <<  "' leaf node");

            return TStaticResourceStateMatchesNodePtr(
                new TStaticResourceStateMatchesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.StaticResourceStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "static_resource_download_hash")
                    , API::EStaticResourceState(ptr->number())
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TWorkloadClearDestroyStatusNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TWorkloadClearDestroyStatusNodePtr(
                new TWorkloadClearDestroyStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TWorkloadClearStopStatusNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TWorkloadClearStopStatusNodePtr(
                new TWorkloadClearStopStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TWorkloadShouldBeDestroyedByHookNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.WorkloadStatusRepositoryInternal_, "WorkloadStatusRepositoryInternal not defined for " << nodeInfo.Getname() << " leaf node");
            return TWorkloadShouldBeDestroyedByHookNodePtr(
                new TWorkloadShouldBeDestroyedByHookNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , context.WorkloadStatusRepositoryInternal_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TWorkloadTargetActiveNode::NODE_TYPE) {
            Y_ENSURE(context.UpdateHolderTarget_, "UpdateHolderTarget not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TWorkloadTargetActiveNodePtr(
                new TWorkloadTargetActiveNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , context.UpdateHolderTarget_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }

    // Ip operations
    , {
        NODE_CREATOR_FUNCTION(TAddIpAddressNode::NODE_TYPE) {
            Y_ENSURE(context.IpClient_, "IpClient not defined for " << nodeInfo.Getname() << " leaf node");
            return TAddIpAddressNodePtr(
                new TAddIpAddressNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.IpClient_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "device")
                    , TIpDescription(
                        TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "address")
                        , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "subnet")
                    )
                )
            );
        }
    }

    // Network
    , {
        NODE_CREATOR_FUNCTION(TCaptureNetworkHookStatusNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TCaptureNetworkHookStatusNodePtr(
                new TCaptureNetworkHookStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , context.SystemLogsSender_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TCheckHttpHookRetriesNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TCheckHttpHookRetriesNodePtr(
                new TCheckHttpHookRetriesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "max_tries")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackHttpHookFailReasonNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TFeedbackHttpHookFailReasonNodePtr(
                new TFeedbackHttpHookFailReasonNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "fail_reason")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackNetworkHookStateNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            NStatusRepositoryTypes::EHookBackend hookBackend = FromString(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"));

            const TString stateString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "state");
            TFeedbackNetworkHookStateNode::TNetworkHookState state;
            if (hookBackend == NStatusRepositoryTypes::EHookBackend::TCP) {
                auto descriptor = API::ETcpCheckState_descriptor();
                auto ptr = descriptor->FindValueByName(stateString);
                Y_ENSURE(ptr, "Could not cast '" << stateString << "' to ETcpCheckState at " << nodeInfo.Getname() << " '" << nodeInfo.Gettitle() <<  "' leaf node");
                state = API::ETcpCheckState(ptr->number());
            } else {
                auto descriptor = API::EHttpGetState_descriptor();
                auto ptr = descriptor->FindValueByName(stateString);
                Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EHttpGetState at " << nodeInfo.Getname() << " '" << nodeInfo.Gettitle() <<  "' leaf node");
                state = API::EHttpGetState(ptr->number());
            }

            return TFeedbackNetworkHookStateNodePtr(
                new TFeedbackNetworkHookStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , hookBackend
                    , state
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TNetworkCheckAndAddRequestNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.NetworkClient_, "NetworkClient not defined for " << nodeInfo.Getname() << " leaf node");

            const TDuration timeout = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "timeout"));

            return TNetworkCheckAndAddRequestNodePtr(
                new TNetworkCheckAndAddRequestNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "request_hash")
                    , context.NetworkClient_
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "port")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , timeout
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TNetworkGetAndRemoveRequestResponseNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.NetworkClient_, "NetworkClient not defined for " << nodeInfo.Getname() << " leaf node");

            return TNetworkGetAndRemoveRequestResponseNodePtr(
                new TNetworkGetAndRemoveRequestResponseNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "request_hash")
                    , context.NetworkClient_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "expected_answer")
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "any_answer"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TNetworkGetRequestStateNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.NetworkClient_, "NetworkClient not defined for " << nodeInfo.Getname() << " leaf node");

            return TNetworkGetRequestStateNodePtr(
                new TNetworkGetRequestStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "request_hash")
                    , context.NetworkClient_
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TNetworkHookConsecutiveTriesReachedNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            return TNetworkHookConsecutiveTriesReachedNodePtr(
                new TNetworkHookConsecutiveTriesReachedNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "count_successes"))
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "tries_threshold")
                )
            );
        }
    }
   , {
        NODE_CREATOR_FUNCTION(TNetworkHookStartTimeExpiredWithBackoffNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            const TDuration minRestartPeriod = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "min_restart_period"));
            const TDuration maxRestartPeriod = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "max_restart_period"));
            const TDuration restartPeriodScale = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "restart_period_scale"));
            const ui64 restartPeriodBackoff = TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "restart_period_back_off");

            return TNetworkHookStartTimeExpiredWithBackoffNodePtr(
                new TNetworkHookStartTimeExpiredWithBackoffNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , FromString<NStatusRepositoryTypes::EHookBackend>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "hook_backend"))
                    , restartPeriodScale
                    , restartPeriodBackoff
                    , maxRestartPeriod
                    , minRestartPeriod
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TNetworkRemoveRequestNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.NetworkClient_, "NetworkClient not defined for " << nodeInfo.Getname() << " leaf node");

            return TNetworkRemoveRequestNodePtr(
                new TNetworkRemoveRequestNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , FromString<NStatusRepositoryTypes::ENetworkHookType>(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "network_hook_type"))
                    , context.NetworkClient_
                )
            );
        }
    }

    // Porto
    , {
        NODE_CREATOR_FUNCTION(TPortoActiveDownloadContainersLimitReachedNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PathHolder_, "PathHolder not defined for " << nodeInfo.Getname() << " leaf node");

            return TPortoActiveDownloadContainersLimitReachedNodePtr(
                new TPortoActiveDownloadContainersLimitReachedNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PathHolder_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoActiveVerifyContainersLimitReachedNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PathHolder_, "PathHolder not defined for " << nodeInfo.Getname() << " leaf node");

            return TPortoActiveVerifyContainersLimitReachedNodePtr(
                new TPortoActiveVerifyContainersLimitReachedNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PathHolder_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoAddPropertiesToObjectFailedMessageNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TVector<TString> propertyStrings = TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(
                TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property_list")
            );
            TVector<EPortoContainerProperty> propertyVector;
            for (const TString& property : propertyStrings) {
                propertyVector.push_back(FromString(property));
            }

            return TPortoAddPropertiesToObjectFailedMessageNodePtr(
                new TPortoAddPropertiesToObjectFailedMessageNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , propertyVector
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoAddPropertiesToContainerFailReasonNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TVector<TString> propertyStrings = TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(
                TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property_list")
            );
            TVector<EPortoContainerProperty> propertyVector;
            for (const TString& property : propertyStrings) {
                propertyVector.push_back(FromString(property));
            }

            return TPortoAddPropertiesToContainerFailReasonNodePtr(
                new TPortoAddPropertiesToContainerFailReasonNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , propertyVector
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoCleanLinkedVolumesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoCleanLinkedVolumesNodePtr(
                new TPortoCleanLinkedVolumesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoCleanOldContainersNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PathHolder_, "PathHolder not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoCleanOldContainersNodePtr(
                new TPortoCleanOldContainersNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PathHolder_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "lookup_container_mask"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoContainerExistsNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoContainerExistsNodePtr(
                new TPortoContainerExistsNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoContainerPrivateMatchesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoContainerPrivateMatchesNodePtr(
                new TPortoContainerPrivateMatchesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                    , FromString(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoContainerPropertyMatchesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TString propertyString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property");
            const EPortoContainerProperty property = FromString(propertyString);

            return TPortoContainerPropertyMatchesNodePtr(
                new TPortoContainerPropertyMatchesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , property
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoContainerTimeExpiredNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TDuration expireDuration = TDuration::MilliSeconds(ExtractNumberValue(nodeInfo, "expire_ms"));
            const TString propertyString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property");
            const TString timeTypeString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "time_type");
            const EPortoContainerProperty property = FromString(propertyString);
            const TPortoContainerTimeExpiredNode::ETimeType timeType = FromString(timeTypeString);

            return TPortoContainerTimeExpiredNodePtr(
                new TPortoContainerTimeExpiredNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , expireDuration
                    , property
                    , timeType
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoContainerTreeHashMatchesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoContainerTreeHashMatchesNodePtr(
                new TPortoContainerTreeHashMatchesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoCreateRecursiveNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoCreateRecursiveNodePtr(
                new TPortoCreateRecursiveNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoCreateVolumeNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            const TString& storage = IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "is_persistent"))
                ? TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "storage")
                : "";
            return TPortoCreateVolumeNodePtr(
                new TPortoCreateVolumeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , storage
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layers"))
                    , TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "static_resource_original_paths"))
                    , TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "static_resource_paths"))
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "quota_bytes")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "private")
                    , FromString(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "backend"))
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "read_only"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoDestroyNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoDestroyNodePtr(
                new TPortoDestroyNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetAndCheckPropertiesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            static const THashSet<TString> notPortoProperties = {
                "container_name"
                , "container_type"
                , "init_num"
                , "object_id_or_hash"
                , "object_type"
                , "tree_hash"
                , "secret_properties_list"
            };

            TMap<EPortoContainerProperty, TString> properties = TBehavior3EditorJsonReader::GetPortoContainerProperties(nodeInfo, notPortoProperties);

            THashSet<EPortoContainerProperty> secretProperties;
            for (const TString& secretProperty :
                TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(
                    TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "secret_properties_list")
                )
            ) {
                secretProperties.insert(FromString<EPortoContainerProperty>(secretProperty));
            }

            return TPortoGetAndCheckPropertiesNodePtr(
                new TPortoGetAndCheckPropertiesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                    , properties
                    , secretProperties
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetAndCheckVolumePropertiesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            TMap<EPortoVolumeProperty, TString> properties;
            for (auto it : nodeInfo.Getproperties()) {
                if (it.first != "path") {
                    TString value = "";
                    if (it.second.kind_case() == NProtoBuf::Value::kNumberValue) {
                        value = ToString(it.second.number_value());
                    } else {
                        value = it.second.string_value();
                    }
                    if (value) {
                        properties[FromString(it.first)] = value;
                    }
                }
            }
            return TPortoGetAndCheckVolumePropertiesNodePtr(
                new TPortoGetAndCheckVolumePropertiesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , properties
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetContainerPrivateNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoGetContainerPrivateNodePtr(
                new TPortoGetContainerPrivateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , ""
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetContainerStateNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoGetContainerStateNodePtr(
                new TPortoGetContainerStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetDownloadProgressNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoGetDownloadProgressNodePtr(
                new TPortoGetDownloadProgressNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "need_check_download_progress"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoGetLayerPrivateNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoGetLayerPrivateNodePtr(
                new TPortoGetLayerPrivateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoImportLayerNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.LayerStatusRepository_, "LayerStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoImportLayerNodePtr(
                new TPortoImportLayerNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.LayerStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_download_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_name")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_place")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_path")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoKillNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoKillNodePtr(
                new TPortoKillNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoLayerExistsNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoLayerExistsNodePtr(
                new TPortoLayerExistsNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoLayersReadyNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoLayersReadyNodePtr(
                new TPortoLayersReadyNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_list"))
                    , TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash_list"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoLinkVolumeNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoLinkVolumeNodePtr(
                new TPortoLinkVolumeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "target")
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "read_only"))
                    , false
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoRemoveLayerNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.LayerStatusRepository_, "LayerStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoRemoveLayerNodePtr(
                new TPortoRemoveLayerNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.LayerStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_download_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_name")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer_place")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoRemoveStorageNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoRemoveStorageNodePtr(
                new TPortoRemoveStorageNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "storage")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoSetContainerPrivateNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoSetContainerPrivateNodePtr(
                new TPortoSetContainerPrivateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "tree_hash")
                    , FromString(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoSetLayerPrivateNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoSetLayerPrivateNodePtr(
                new TPortoSetLayerPrivateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "layer")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoSetPropertyNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TString propertyString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property");
            const EPortoContainerProperty property = FromString(propertyString);

            bool isValueSecret = false;
            for (const TString& secretProperty :
                TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(
                    TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "secret_properties_list")
                )
            ) {
                if (FromString<EPortoContainerProperty>(secretProperty) == property) {
                    isValueSecret = true;
                    break;
                }
            }

            return TPortoSetPropertyNodePtr(
                new TPortoSetPropertyNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , property
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value")
                    , isValueSecret
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoSetPropertiesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            static const THashSet<TString> notPortoProperties = {
                "container_name"
                , "container_type"
                , "init_num"
                , "object_id_or_hash"
                , "object_type"
            };

            TMap<EPortoContainerProperty, TString> properties;
            for (const auto& [property, value] : TBehavior3EditorJsonReader::GetPortoContainerProperties(nodeInfo, notPortoProperties)) {
                if (!value.empty()) {
                    properties[property] = value;
                }
            }

            return TPortoSetPropertiesNodePtr(
                new TPortoSetPropertiesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , properties
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoStartNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoStartNodePtr(
                new TPortoStartNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoStaticResourceVerifyContainerTimeExpiredNode::NODE_TYPE) {
            Y_ENSURE(context.StaticResourceStatusRepository_, "StaticResourceStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");

            const TString propertyString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "property");
            const EPortoContainerProperty property = FromString(propertyString);

            return TPortoStaticResourceVerifyContainerTimeExpiredNodePtr(
                new TPortoStaticResourceVerifyContainerTimeExpiredNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.StaticResourceStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "static_resource_download_hash")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , property
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoStopNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoStopNodePtr(
                new TPortoStopNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoStoragePrivateMatchesNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoStoragePrivateMatchesNodePtr(
                new TPortoStoragePrivateMatchesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "storage")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "value")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoStorageExistsNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoStorageExistsNodePtr(
                new TPortoStorageExistsNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "place")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "storage")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoUnlinkVolumeNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoUnlinkVolumeNodePtr(
                new TPortoUnlinkVolumeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "target")
                    , false
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoVolumeExistsNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoVolumeExistsNodePtr(
                new TPortoVolumeExistsNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoVolumeIsLinkOfNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoVolumeIsLinkOfNodePtr(
                new TPortoVolumeIsLinkOfNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "target")
                    , IsTrue(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "read_only"))
                    , false
                )
            );
        }
    }

    // Posix
    , {
        NODE_CREATOR_FUNCTION(TCheckSameINodeNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TCheckSameINodeNodePtr(
                new TCheckSameINodeNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path1")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path2")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFileExistNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TFileExistNodePtr(
                new TFileExistNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , context.PosixWorker_
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TIsDirectoryNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TIsDirectoryNodePtr(
                new TIsDirectoryNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , context.PosixWorker_
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFileModifiedBeforePortoContainerStartNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PosixWorker_, "posix worker not defined for " <<  nodeInfo.Getname() << " leaf node");
            return TFileModifiedBeforePortoContainerStartNodePtr(
                new TFileModifiedBeforePortoContainerStartNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PosixWorker_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFileModifiedBeforePortoVolumeBuildNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PosixWorker_, "posix worker not defined for " <<  nodeInfo.Getname() << " leaf node");
            return TFileModifiedBeforePortoVolumeBuildNodePtr(
                new TFileModifiedBeforePortoVolumeBuildNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "volume_path")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "file_path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFileModifiedRecursiveBeforePortoContainerStartNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.PosixWorker_, "posix worker not defined for " <<  nodeInfo.Getname() << " leaf node");
            return TFileModifiedRecursiveBeforePortoContainerStartNodePtr(
                new TFileModifiedRecursiveBeforePortoContainerStartNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.PosixWorker_
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TMakeDirectoryNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TMakeDirectoryNodePtr(
                new TMakeDirectoryNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TMakeHardLinkNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TMakeHardLinkNodePtr(
                new TMakeHardLinkNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "existing_path")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "link_path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TMakeLogFileNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TMakeLogFileNodePtr(
                new TMakeLogFileNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractContainerDescription(nodeInfo)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TMakeSymLinkNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TMakeSymLinkNodePtr(
                new TMakeSymLinkNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "existing_path")
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "link_path")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TRemoveFileNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TRemoveFileNodePtr(
                new TRemoveFileNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , context.PosixWorker_
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TRemoveRecursiveNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            return TRemoveRecursiveNodePtr(
                new TRemoveRecursiveNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , context.PosixWorker_
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TSetFileAccessModeRecursiveNode::NODE_TYPE) {
            Y_ENSURE(context.PosixWorker_, "PosixWorker not defined for " << nodeInfo.Getname() << " leaf node");
            TString accessModeStr = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "access_mode");
            EFileAccessMode accessMode = accessModeStr.empty() ? EFileAccessMode::Mode_UNMODIFIED : FromString(accessModeStr);

            return TSetFileAccessModeRecursiveNodePtr(
                new TSetFileAccessModeRecursiveNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.PosixWorker_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "path")
                    , accessMode
                    , TBehavior3EditorJsonReader::ExtractStatusRepository(nodeInfo, context)
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "object_id_or_hash")
                )
            );
        }
    }

    // Unix signal
    , {
        NODE_CREATOR_FUNCTION(TCaptureUnixSignalStatusNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TCaptureUnixSignalStatusNodePtr(
                new TCaptureUnixSignalStatusNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , context.SystemLogsSender_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TCheckUnixSignalRetriesNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TCheckUnixSignalRetriesNodePtr(
                new TCheckUnixSignalRetriesNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "max_tries")
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TFeedbackUnixSignalStateNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            const TString stateString = TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "state");
            const auto descriptor = API::EUnixSignalState_descriptor();
            const auto ptr = descriptor->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EUnixSignalState at " << nodeInfo.Getname() << " '" << nodeInfo.Gettitle() <<  "' leaf node");
            const API::EUnixSignalState state = API::EUnixSignalState(ptr->number());

            return TFeedbackUnixSignalStateNodePtr(
                new TFeedbackUnixSignalStateNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , state
                )
            );
        }
    }
    , {
        NODE_CREATOR_FUNCTION(TPortoKillWithUnixSignalFeedbackNode::NODE_TYPE) {
            Y_ENSURE(context.Porto_, "porto not defined for " << nodeInfo.Getname() << " leaf node");
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");
            return TPortoKillWithUnixSignalFeedbackNodePtr(
                new TPortoKillWithUnixSignalFeedbackNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.Porto_
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , TPortoContainerName::NoEscape(TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "container_name"))
                    , TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "signal")
                )
            );
        }
    }
   , {
        NODE_CREATOR_FUNCTION(TUnixSignalSendTimeExpiredWithBackoffNode::NODE_TYPE) {
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << nodeInfo.Getname() << " leaf node");

            const TDuration minRestartPeriod = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "min_restart_period"));
            const TDuration maxRestartPeriod = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "max_restart_period"));
            const TDuration restartPeriodScale = TDuration::MilliSeconds(TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "restart_period_scale"));
            const ui64 restartPeriodBackoff = TBehavior3EditorJsonReader::ExtractNumberValue(nodeInfo, "restart_period_back_off");

            return TUnixSignalSendTimeExpiredWithBackoffNodePtr(
                new TUnixSignalSendTimeExpiredWithBackoffNode(
                    {nodeId, nodeInfo.Gettitle()}
                    , context.WorkloadStatusRepository_
                    , TBehavior3EditorJsonReader::ExtractStringValue(nodeInfo, "workload_id")
                    , restartPeriodScale
                    , restartPeriodBackoff
                    , maxRestartPeriod
                    , minRestartPeriod
                )
            );
        }
    }
};

#undef NODE_CREATOR_FUNCTION
#undef NODE_CREATOR_FUNCTION_NO_CONTEXT
#undef NODE_CREATOR_FUNCTION_WITH_TREE

TBasicTreeNodePtr TBehavior3EditorJsonReader::BuildRootNode() {
    return BuildNode(Tree_.root());
}

TBasicTreeNodePtr TBehavior3EditorJsonReader::BuildNode(const TString& rootNodeId) {
    THashSet<TString> discovered;
    discovered.insert(rootNodeId);

    THashMap<TString, TBasicTreeNodePtr> nodes;

    while (!discovered.empty()) {
        auto begIt = discovered.begin();
        const TString id = *begIt;
        auto it = Tree_.nodes().find(id);
        Y_ENSURE(it != Tree_.nodes().end(), "no node '" << id << "' at TBehavior3");
        const TBehavior3Node& focusedOn = it->second;
        if (IsSimpleCompositeNode(focusedOn)) {
            TVector<TString> children;
            for (auto&& discoveredChildId : focusedOn.Getchildren()) {
                children.push_back(discoveredChildId);
            }
            if (focusedOn.has_child()) {
                children.push_back(focusedOn.Getchild());
            }
            TVector<TBasicTreeNodePtr> childrenNodes;
            for (TString& discoveredChildId : children) {
                auto&& discoveredChildNode = Tree_.nodes().at(discoveredChildId);
                discovered.insert(discoveredChildId);

                childrenNodes.push_back(GetOrCreateNode(discoveredChildNode, nodes));
            }

            auto node = GetOrCreateNode(focusedOn, nodes);
            auto compositeNode = dynamic_cast<TBasicCompositeNode*>(node.Get());
            Y_ENSURE(compositeNode, "Expected composite node but '" << ToString(node->GetType()) << "' found");
            compositeNode->SetChildren(std::move(childrenNodes));
        } else {
            GetOrCreateNode(focusedOn, nodes);
        }

        discovered.erase(begIt);
    }

    return nodes[rootNodeId];
}

bool TBehavior3EditorJsonReader::IsSimpleCompositeNode(const TBehavior3Node& behavior3Node) {
    static const TString MEM_SEQUENCE_GENERATOR_NODE_NAME = ToString(ENodeType::MEM_SEQUENCE_GENERATOR);
    return (!behavior3Node.Getchildren().empty() || behavior3Node.has_child()) && (behavior3Node.Getname() != MEM_SEQUENCE_GENERATOR_NODE_NAME);
}

TBasicTreeNodePtr TBehavior3EditorJsonReader::GetOrCreateNode(
    const TBehavior3Node& behavior3Node
    , THashMap<TString, TBasicTreeNodePtr>& nodes
) {
    if (nodes.contains(behavior3Node.Getid())) {
        return nodes[behavior3Node.Getid()];
    }

    try {
        auto result = CreateNode(behavior3Node);
        nodes[behavior3Node.Getid()] = result;
        return result;
    } catch (yexception& e) {
        throw e << " while creating node '" << behavior3Node.Getname() << "' with id '" << behavior3Node.Getid() << "'";
    }
}

TBasicTreeNodePtr TBehavior3EditorJsonReader::CreateNode(const TBehavior3Node& behavior3Node) {
    const ui64 nodeId = CombineHashes(ParentId_, FromString<ui64>(behavior3Node.Getid()));

    // Special case: Tree root
    if (Context_.TemplateBTStorage_ && Context_.TemplateBTStorage_->Has(behavior3Node.Getname())) {
        // subtree
        TBehavior3 resolvedTree = Context_.TemplateBTStorage_->Get(behavior3Node.Getname());
        {
            // node properties are RSLV map for subtree
            TMap<TString, TString> replace;
            for (auto& it : behavior3Node.Getproperties()) {
                if (it.second.kind_case() == NProtoBuf::Value::kNumberValue) {
                    replace[it.first] = ToString(it.second.number_value());
                } else {
                    replace[it.first] = it.second.string_value();
                }
            }
            TBehavior3TemplateResolver().Resolve(resolvedTree, replace);
        }
        return TBehavior3EditorJsonReader(resolvedTree, nodeId)
            .WithContext(Context_)
            .BuildRootNode()
        ;
    }

    ENodeType nodeType = FromString<ENodeType>(behavior3Node.Getname());

    auto nodeCreatorPtr = NODE_CREATORS.FindPtr(nodeType);
    Y_ENSURE(nodeCreatorPtr, "CreateNode for '" << ToString(nodeType) << "' not implemented");

    auto node = (*nodeCreatorPtr)(nodeId, behavior3Node, Context_, Tree_);
    Y_ENSURE(
        node->GetType() == nodeType
            // When generator has no children NodeType is MOCK because MEM_SEQUENCE node must have at least one child
            || (nodeType == ENodeType::MEM_SEQUENCE_GENERATOR && (node->GetType() == ENodeType::MEM_SEQUENCE || node->GetType() == ENodeType::MOCK))
        , "Wrong node created. Expected: '" << ToString(nodeType) << "', found: '" << node->GetType() << "'"
    );

    return node;
}

ui64 TBehavior3EditorJsonReader::ExtractNumberValue(const TBehavior3Node &behavior3Node, const char* name) {
    auto value = GetProtoMapAtSafe(behavior3Node.Getproperties(), ToString(name));
    if (value.kind_case() == NProtoBuf::Value::kNumberValue) {
        return value.number_value();
    } else {
        if (value.string_value() == "") {
            return 0;
        }
        return FromString<ui64>(value.string_value());
    }
}

TString TBehavior3EditorJsonReader::ExtractStringValue(const TBehavior3Node& behavior3Node, const char* name) {
    auto value = GetProtoMapAtSafe(behavior3Node.Getproperties(), TString(name));
    if (value.kind_case() == NProtoBuf::Value::kStringValue)
        return value.string_value();
    if (value.kind_case() == NProtoBuf::Value::kNumberValue) {
        return ToString(value.number_value());
    }
    ythrow yexception() << "Unexpected Value type";
}

NStatusRepositoryTypes::TContainerDescription TBehavior3EditorJsonReader::ExtractContainerDescription(const TBehavior3Node& behavior3Node) {
    const TString id = ExtractStringValue(behavior3Node, "object_id_or_hash");
    const NStatusRepositoryTypes::EObjectType objectType = FromString<NStatusRepositoryTypes::EObjectType>(
        ExtractStringValue(behavior3Node, "object_type")
    );
    const NStatusRepositoryTypes::TContainerDescription::EContainerType containerType = FromString<NStatusRepositoryTypes::TContainerDescription::EContainerType>(
        ExtractStringValue(behavior3Node, "container_type")
    );

    if (containerType == NStatusRepositoryTypes::TContainerDescription::EContainerType::INIT) {
        return NStatusRepositoryTypes::TContainerDescription(
            id
            , objectType
            , containerType
            , ExtractNumberValue(behavior3Node, "init_num")
        );
    } else {
        return NStatusRepositoryTypes::TContainerDescription(
            id
            , objectType
            , containerType
        );
    }
}

TStatusRepositoryCommonPtr TBehavior3EditorJsonReader::ExtractStatusRepository(
    const TBehavior3Node& behavior3Node
    , const TBehavior3Context& context
) {
    NStatusRepositoryTypes::EObjectType objectType = FromString<NStatusRepositoryTypes::EObjectType>(
        ExtractStringValue(behavior3Node, "object_type")
    );
    switch (objectType) {
        case NStatusRepositoryTypes::EObjectType::BOX:
            Y_ENSURE(context.BoxStatusRepository_, "BoxStatusRepository not defined for " << behavior3Node.Getname() << " leaf node");
            return context.BoxStatusRepository_;
        case NStatusRepositoryTypes::EObjectType::LAYER:
            Y_ENSURE(context.LayerStatusRepository_, "LayerStatusRepository not defined for " << behavior3Node.Getname() << " leaf node");
            return context.LayerStatusRepository_;
        case NStatusRepositoryTypes::EObjectType::STATIC_RESOURCE:
            Y_ENSURE(context.StaticResourceStatusRepository_, "StaticResourceStatusRepository not defined for " << behavior3Node.Getname() << " leaf node");
            return context.StaticResourceStatusRepository_;
        case NStatusRepositoryTypes::EObjectType::VOLUME:
            Y_ENSURE(context.VolumeStatusRepository_, "VolumeStatusRepository not defined for " << behavior3Node.Getname() << " leaf node");
            return context.VolumeStatusRepository_;
        case NStatusRepositoryTypes::EObjectType::WORKLOAD:
            Y_ENSURE(context.WorkloadStatusRepository_, "WorkloadStatusRepository not defined for " << behavior3Node.Getname() << " leaf node");
            return context.WorkloadStatusRepository_;
    }
}

TStatusRepositoryCommon::TObjectState TBehavior3EditorJsonReader::ExtractObjectState(const TBehavior3Node& behavior3Node) {
    NStatusRepositoryTypes::EObjectType objectType = FromString<NStatusRepositoryTypes::EObjectType>(
        ExtractStringValue(behavior3Node, "object_type")
    );
    TString stateString = ExtractStringValue(behavior3Node, "state");

    switch (objectType) {
        case NStatusRepositoryTypes::EObjectType::BOX: {
            auto ptr = API::EBoxState_descriptor()->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EBoxState at " << behavior3Node.Getname() << " '" << behavior3Node.Gettitle() <<  "' leaf node");
            return API::EBoxState(ptr->number());
        }
        case NStatusRepositoryTypes::EObjectType::LAYER: {
            auto ptr = API::ELayerState_descriptor()->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to ELayerState at " << behavior3Node.Getname() << " '" << behavior3Node.Gettitle() <<  "' leaf node");
            return API::ELayerState(ptr->number());
        }
        case NStatusRepositoryTypes::EObjectType::STATIC_RESOURCE: {
            auto ptr = API::EStaticResourceState_descriptor()->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EStaticResourceState at " << behavior3Node.Getname() << " '" << behavior3Node.Gettitle() <<  "' leaf node");
            return API::EStaticResourceState(ptr->number());
        }
        case NStatusRepositoryTypes::EObjectType::VOLUME: {
            auto ptr = API::EVolumeState_descriptor()->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EVolumeState at " << behavior3Node.Getname() << " '" << behavior3Node.Gettitle() <<  "' leaf node");
            return API::EVolumeState(ptr->number());
        }
        case NStatusRepositoryTypes::EObjectType::WORKLOAD: {
            auto ptr = API::EWorkloadState_descriptor()->FindValueByName(stateString);
            Y_ENSURE(ptr, "Could not cast '" << stateString << "' to EWorkloadState at " << behavior3Node.Getname() << " '" << behavior3Node.Gettitle() <<  "' leaf node");
            return API::EWorkloadState(ptr->number());
        }
    }
}

TString TBehavior3EditorJsonReader::EscapeCharactersForMemSequenceGenerator(const TVector<TString>& stringList) {
    TStringBuilder stringWithEscapeCharacters;

    for (const TString& string : stringList) {
        for (auto symb : string) {
            if (symb == ';') {
                stringWithEscapeCharacters << '\\';
            }
            stringWithEscapeCharacters << symb;
        }
        stringWithEscapeCharacters << ";";
    }

    return stringWithEscapeCharacters;
}

TVector<TString> TBehavior3EditorJsonReader::SplitAndUnescapeCharactersForMemSequenceGenerator(const TString& stringForSplit) {
    TVector<TString> parts;

    if (stringForSplit.empty()) {
        return parts;
    }

    char lastSymb = ';';
    TString currentToken = "";
    for (auto symb : stringForSplit) {
        if (symb == ';' && lastSymb != '\\') {
            parts.push_back(currentToken);
            currentToken = "";
        } else {
            if (symb == ';' && lastSymb == '\\') {
                currentToken.pop_back(); // Remove escape character
            }

            currentToken.push_back(symb);
        }

        lastSymb = symb;
    }
    Y_ENSURE(currentToken.empty(), "last token also should end with ';'");
    return parts;
}

TMap<EPortoContainerProperty, TString> TBehavior3EditorJsonReader::GetPortoContainerProperties(
    const TBehavior3Node& node,
    const THashSet<TString>& notPortoProperties
) {
    TMap<EPortoContainerProperty, TString> properties;
    for (const auto& it : node.Getproperties()) {
        if (!notPortoProperties.contains(it.first)) {
            TString value = "";
            if (it.second.kind_case() == NProtoBuf::Value::kNumberValue) {
                value = ToString(it.second.number_value());
            } else {
                value = it.second.string_value();
            }

            properties[FromString<EPortoContainerProperty>(it.first)] = value;
        }
    }
    return properties;
}

} // namespace NInfra::NPodAgent
