#pragma once

#include <infra/pod_agent/libs/behaviour/bt/core/basic_tree_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_composite_node.h>
#include <infra/pod_agent/libs/behaviour/loaders/proto/behavior3.pb.h>
#include <infra/pod_agent/libs/behaviour/template_bt_storage/template_bt_storage.h>

#include <infra/pod_agent/libs/ip_client/async_client.h>
#include <infra/pod_agent/libs/network_client/client.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/porto_client/async_client.h>
#include <infra/pod_agent/libs/posix_worker/posix_worker.h>
#include <infra/pod_agent/libs/system_logs_sender/system_logs_sender.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/box_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/static_resource_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/volume_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository_internal/workload_status_repository_internal.h>
#include <infra/pod_agent/libs/pod_agent/update_holder/update_holder.h>

#include <util/generic/hash_set.h>
#include <util/generic/hash.h>

namespace NInfra::NPodAgent {

class TBehavior3EditorJsonReader {
public:
    struct TBehavior3Context {
        TBehavior3Context()
            : IpClient_(nullptr)
            , Porto_(nullptr)
            , PosixWorker_(nullptr)
            , NetworkClient_(nullptr)
            , UpdateHolderTarget_(nullptr)
            , BoxStatusRepository_(nullptr)
            , LayerStatusRepository_(nullptr)
            , StaticResourceStatusRepository_(nullptr)
            , VolumeStatusRepository_(nullptr)
            , WorkloadStatusRepository_(nullptr)
            , WorkloadStatusRepositoryInternal_(nullptr)
            , SystemLogsSender_(nullptr)
        {}


        TAsyncIpClientPtr IpClient_;
        TAsyncPortoClientPtr Porto_;
        TPosixWorkerPtr PosixWorker_;
        TNetworkClientPtr NetworkClient_;

        TUpdateHolderTargetPtr UpdateHolderTarget_;

        TBoxStatusRepositoryPtr BoxStatusRepository_;
        TLayerStatusRepositoryPtr LayerStatusRepository_;
        TStaticResourceStatusRepositoryPtr StaticResourceStatusRepository_;
        TVolumeStatusRepositoryPtr VolumeStatusRepository_;
        TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;

        TWorkloadStatusRepositoryInternalPtr WorkloadStatusRepositoryInternal_;
        ISystemLogsSenderPtr SystemLogsSender_;

        TTemplateBTStoragePtr TemplateBTStorage_;
        TPathHolderPtr PathHolder_;
    };

public:
    TBehavior3EditorJsonReader(const TBehavior3& tree, ui64 parentId = 0)
        : Tree_(tree)
        , ParentId_(parentId)
        , Context_()
    {}

    TBehavior3EditorJsonReader& WithContext(const TBehavior3Context& context) {
        Context_ = context;
        return *this;
    }

    TBehavior3EditorJsonReader& WithIpClient(TAsyncIpClientPtr ipClient) {
        Context_.IpClient_ = ipClient;
        return *this;
    }

    TBehavior3EditorJsonReader& WithPorto(TAsyncPortoClientPtr porto) {
        Context_.Porto_ = porto;
        return *this;
    }

    TBehavior3EditorJsonReader& WithPosixWorker(TPosixWorkerPtr posixWorker) {
        Context_.PosixWorker_ = posixWorker;
        return *this;
    }

    TBehavior3EditorJsonReader& WithNetworkClient(TNetworkClientPtr networkClient) {
        Context_.NetworkClient_ = networkClient;
        return *this;
    }

    TBehavior3EditorJsonReader& WithUpdateHolderTarget(TUpdateHolderTargetPtr updateHolderTarget) {
        Context_.UpdateHolderTarget_ = updateHolderTarget;
        return *this;
    }

    TBehavior3EditorJsonReader& WithBoxStatusRepository(TBoxStatusRepositoryPtr boxStatusRepository) {
        Context_.BoxStatusRepository_ = boxStatusRepository;
        return *this;
    }

    TBehavior3EditorJsonReader& WithLayerStatusRepository(TLayerStatusRepositoryPtr layerStatusRepository) {
        Context_.LayerStatusRepository_ = layerStatusRepository;
        return *this;
    }

    TBehavior3EditorJsonReader& WithStaticResourceStatusRepository(TStaticResourceStatusRepositoryPtr staticResourceStatusRepository) {
        Context_.StaticResourceStatusRepository_ = staticResourceStatusRepository;
        return *this;
    }

    TBehavior3EditorJsonReader& WithVolumeStatusRepository(TVolumeStatusRepositoryPtr volumeStatusRepository) {
        Context_.VolumeStatusRepository_ = volumeStatusRepository;
        return *this;
    }

    TBehavior3EditorJsonReader& WithWorkloadStatusRepository(TWorkloadStatusRepositoryPtr workloadStatusRepository) {
        Context_.WorkloadStatusRepository_ = workloadStatusRepository;
        return *this;
    }

    TBehavior3EditorJsonReader& WithTemplateBTStorage(TTemplateBTStoragePtr templateBTStorage) {
        Context_.TemplateBTStorage_ = templateBTStorage;
        return *this;
    }

    TBehavior3EditorJsonReader& WithWorkloadInternalStatusRepository(TWorkloadStatusRepositoryInternalPtr workloadStatusRepositoryInternal) {
        Context_.WorkloadStatusRepositoryInternal_ = workloadStatusRepositoryInternal;
        return *this;
    }

    TBehavior3EditorJsonReader& WithPathHolder(TPathHolderPtr pathHolder) {
        Context_.PathHolder_ = pathHolder;
        return *this;
    }

    TBehavior3EditorJsonReader& WithSystemLogsSender(ISystemLogsSenderPtr systemLogsSender) {
        Context_.SystemLogsSender_ = systemLogsSender;
        return *this;
    }

    TBasicTreeNodePtr BuildRootNode();
    TBasicTreeNodePtr BuildNode(const TString& nodeId);

    static ui64 ExtractNumberValue(const TBehavior3Node& behavior3Node, const char* name);
    static TString ExtractStringValue(const TBehavior3Node& behavior3Node, const char* name);
    static NStatusRepositoryTypes::TContainerDescription ExtractContainerDescription(const TBehavior3Node& behavior3Node);
    static TStatusRepositoryCommonPtr ExtractStatusRepository(
        const TBehavior3Node& behavior3Node
        , const TBehavior3Context& context
    );
    static TStatusRepositoryCommon::TObjectState ExtractObjectState(const TBehavior3Node& behavior3Node);

    // google::protobuf::Map.at() aborts if key not found - that's not good
    template<typename Key, typename T>
    static const T& GetProtoMapAtSafe(const google::protobuf::Map<Key, T>& map, Key&& key) {
        auto it = map.find(key);
        Y_ENSURE(it != map.end(), "key '" << key <<  "' not found at protobuf::Map");
        return it->second;
    }

    static TString EscapeCharactersForMemSequenceGenerator(const TVector<TString>& stringList);
    static TVector<TString> SplitAndUnescapeCharactersForMemSequenceGenerator(const TString& stringForSplit);

    static TMap<EPortoContainerProperty, TString> GetPortoContainerProperties(
        const TBehavior3Node& node,
        const THashSet<TString>& notPortoProperties
    );

private:
    bool IsSimpleCompositeNode(const TBehavior3Node& behavior3Node);

    TBasicTreeNodePtr GetOrCreateNode(
        const TBehavior3Node& behavior3Node
        , THashMap<TString, TBasicTreeNodePtr>& nodes
    );
    TBasicTreeNodePtr CreateNode(
        const TBehavior3Node& behavior3Node
    );

private:
    const TBehavior3 Tree_;
    ui64 ParentId_;

    TBehavior3Context Context_;

    static THashMap<
        ENodeType
        , std::function<
            TBasicTreeNodePtr(
                const ui64 nodeId
                , const TBehavior3Node& nodeInfo
                , const TBehavior3Context& context
                , const TBehavior3& tree
            )
        >
    > NODE_CREATORS;
};

} // namespace NInfra::NPodAgent
