#include "behavior3_template_resolver.h"

#include <util/generic/hash_set.h>
#include <util/generic/vector.h>
#include <util/generic/yexception.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

namespace {
    TString ResolveValue(const TString& val, const TString& prefix, const TMap<TString, TString>& replace) {
        size_t pos = 0;
        TStringBuilder result;
        while (pos < val.size()) {
            size_t start = val.find("<" + prefix + ":", pos);
            result << TStringBuf(val, pos, start - pos);
            if (start == TString::npos) {
                break;
            }
            size_t end = val.find('>', start + 6);
            if (end == TString::npos) {
                ythrow yexception() << "Unended template '" << TStringBuf(val, start + 1, TString::npos);
            }

            TStringBuf it(val, start + 6, end - (start + 6));
            auto ptr = replace.FindPtr(it);
            if (ptr) {
                result << *ptr;
            } else {
                ythrow yexception() << "Template '" << it << "' not found at replace map";
            }
            pos = end + 1;
        }
        return TString(result);
    }
}

void TBehavior3TemplateResolver::Resolve(TBehavior3& tree, const TMap<TString, TString>& replace) {
    ResolveNode(tree, tree.Getroot(), "RSLV", replace);
}

void TBehavior3TemplateResolver::ResolveNode(TBehavior3& tree, const TString& rootNodeId, const TString& prefix, const TMap<TString, TString>& replace) {
    THashSet<TString> discovered;
    discovered.insert(rootNodeId);

    while (!discovered.empty()) {
        auto begIt = discovered.begin();
        const TString id = *begIt;
        auto it = tree.Mutablenodes()->find(id);
        Y_ENSURE(it != tree.Mutablenodes()->end(), "no node '" << id << "' at TBehavior3");
        TBehavior3Node& node = it->second;
        try {
            node.Settitle(ResolveValue(node.Gettitle(), prefix, replace));
        } catch (yexception& e) {
            throw e << " at node '" << id << "'"
                << " title '" << node.Gettitle() << "'";
        }
        for (auto& prop : *(node.Mutableproperties())) {
            if (TString val = prop.second.string_value()) {
                try {
                    prop.second.set_string_value(ResolveValue(val, prefix, replace));
                } catch (yexception& e) {
                    throw e << " at"
                        << " node '" << id << "'"
                        << " property '" << prop.first << "'"
                        << " value '" << val << "'";
                }
            }
        }

        TVector<TString> children;
        for (auto&& discoveredChildId : node.Getchildren()) {
            children.push_back(discoveredChildId);
        }
        if (node.has_child()) {
            children.push_back(node.Getchild());
        }
        for (TString& discoveredChildId : children) {
            discovered.insert(discoveredChildId);
        }
        discovered.erase(begIt);
    }
}

} // namespace NInfra::NPodAgent
