#include "template_bt_storage.h"

#include <google/protobuf/util/json_util.h>

#include <util/generic/yexception.h>
#include <util/stream/file.h>

namespace NInfra::NPodAgent {

TTemplateBTStorage::TTemplateBTStorage(const TTemplateBTStorageConfig& config) {
    for (auto& it : config.GetTreeDirs()) {
        for (auto& paths : LoadPaths(it)) {
            TBehavior3 tree = LoadTreeTemplate(paths.Key.data());
            Trees_[tree.Gettitle()] = tree;
        }
    }

    for (auto& it : config.GetTreePaths()) {
        TBehavior3 tree = LoadTreeTemplate(it);
        Trees_[tree.Gettitle()] = tree;
    }
}

TBehavior3 TTemplateBTStorage::Get(const TString& key) const {
    try {
        return Trees_.at(key);
    } catch (const std::exception& e) {
        throw yexception() << e.what() << ". Tree with key '" << key << "' not found.";
    }
}

NResource::TResources TTemplateBTStorage::LoadPaths(const TString& dir) const {
    NResource::TResources out;
    NResource::FindMatch(dir, &out);
    return out;
}

TBehavior3 TTemplateBTStorage::LoadTreeTemplate(const TString& path) const {
    TString jsonTree;
    try {
        jsonTree = TFileInput(path).ReadAll();
    } catch (yexception& e) {
        e << " While trying to open file '" << path << "'.\n";
        try {
            jsonTree = NResource::Find(path);
        } catch (yexception& other) {
            throw e << other.what() << " While trying to open resource '" << path << "'.";
        }
    }

    TBehavior3 protoTreeTemplate;
    google::protobuf::util::JsonParseOptions options;
    options.ignore_unknown_fields = true;
    auto status = JsonStringToMessage(jsonTree, &protoTreeTemplate, options);
    Y_ENSURE(status.ok(), "Could not parse json template tree " << path << ": " << status.message().ToString());

    auto& root = protoTreeTemplate.mutable_nodes()->at(protoTreeTemplate.Getroot());
    root.set_title("Root:" + protoTreeTemplate.title() + ":" + root.title());

    return protoTreeTemplate;
}

} // namespace NInfra::NPodAgent
