#pragma once

#include <infra/pod_agent/libs/behaviour/loaders/proto/behavior3.pb.h>
#include <infra/pod_agent/libs/config/config.pb.h>

#include <library/cpp/resource/resource.h>

#include <util/generic/map.h>

namespace NInfra::NPodAgent {

class ITemplateBTStorage;
using TTemplateBTStoragePtr = TIntrusivePtr<ITemplateBTStorage>;

class ITemplateBTStorage: public TAtomicRefCount<ITemplateBTStorage> {
public:
    virtual ~ITemplateBTStorage() = default;

    virtual TBehavior3 Get(const TString& key) const = 0;
    virtual bool Has(const TString& key) const = 0;
};

class TTemplateBTStorage: public ITemplateBTStorage {
public:
    TTemplateBTStorage(const TTemplateBTStorageConfig& config);

    TBehavior3 Get(const TString& key) const override;
    bool Has(const TString& key) const override {
        return Trees_.contains(key);
    }

private:
    TBehavior3 LoadTreeTemplate(const TString& path) const;
    NResource::TResources LoadPaths(const TString& dir) const;

private:
    TMap<TString, TBehavior3> Trees_;
};

} // namespace NInfra::NPodAgent
