#include "template_bt_storage.h"

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestTemplateBtStorage {

Y_UNIT_TEST_SUITE(TemplateBTStorageSuite) {

Y_UNIT_TEST(TestAddTrees) {
    TTemplateBTStorageConfig config;
    config.AddTreePaths(ArcadiaSourceRoot() + "/infra/pod_agent/libs/behaviour/template_bt_storage/ut/tree.json");
    TTemplateBTStoragePtr storage = new TTemplateBTStorage(config);
    UNIT_ASSERT_EQUAL(true, storage->Has("CheckAndCreateContainer"));
    TBehavior3 tree = storage->Get("CheckAndCreateContainer");
    UNIT_ASSERT_EQUAL("CheckAndCreateContainer", tree.Gettitle());
    UNIT_ASSERT_EQUAL("13bd7793-f8dc-45d2-8933-f7a4ef951197", tree.Getroot());
}

Y_UNIT_TEST(TestAddTreesAsNResource) {
    TTemplateBTStorageConfig config;
    config.AddTreePaths("/pod_agent/libs/behaviour/template_bt_storage/ut/tree.json");
    TTemplateBTStoragePtr storage = new TTemplateBTStorage(config);
    UNIT_ASSERT_EQUAL(true, storage->Has("CheckAndCreateContainer"));
    TBehavior3 tree = storage->Get("CheckAndCreateContainer");
    UNIT_ASSERT_EQUAL("CheckAndCreateContainer", tree.Gettitle());
    UNIT_ASSERT_EQUAL("13bd7793-f8dc-45d2-8933-f7a4ef951197", tree.Getroot());
}

Y_UNIT_TEST(TestNotExists) {
    TTemplateBTStorageConfig config;
    config.AddTreePaths(ArcadiaSourceRoot() + "/infra/pod_agent/libs/behaviour/template_bt_storage/ut/tree.json");
    TTemplateBTStoragePtr storage = new TTemplateBTStorage(config);
    UNIT_ASSERT_EXCEPTION(storage->Get("NotExsits"), yexception);
}

Y_UNIT_TEST(FileNotExists) {
    TTemplateBTStorageConfig config;
    config.AddTreePaths(ArcadiaSourceRoot() + "/infra/pod_agent/libs/behaviour/template_bt_storage/ut/tree_not_exists.json");
    UNIT_ASSERT_EXCEPTION(new TTemplateBTStorage(config), yexception);
}

Y_UNIT_TEST(TestPathDir) {
    TTemplateBTStorageConfig config;
    config.AddTreeDirs("/pod_agent/libs/behaviour/template_bt_storage/ut/");
    TTemplateBTStoragePtr storage = new TTemplateBTStorage(config);

    UNIT_ASSERT_EQUAL(true, storage->Has("CheckAndCreateContainer"));
    TBehavior3 tree = storage->Get("CheckAndCreateContainer");
    UNIT_ASSERT_EQUAL("CheckAndCreateContainer", tree.Gettitle());
    UNIT_ASSERT_EQUAL("13bd7793-f8dc-45d2-8933-f7a4ef951197", tree.Getroot());
}

}

} // namespace NInfra::NPodAgent::NTestTemplateBtStorage
