#include "box_test_canon.h"

#include <infra/pod_agent/libs/behaviour/loaders/behavior3_editor_json_reader.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/folder/dirut.h>
#include <util/system/shellcommand.h>

namespace NInfra::NPodAgent::NTreeTest {

TMap<TString, TString> ITestBoxCanon::GetReplace() const {
    TMap<TString, TString> replace;

    replace["BOX_ID"] = BoxId_;
    replace["BOX_CONTAINER"] = PathHolder_->GetBoxContainer(BoxId_);
    replace["BOX_CONTAINER_PLACE"] = "";

    replace["BOX_CPU_GUARANTEE"] = "2c";
    replace["BOX_CPU_LIMIT"] = "1c";
    replace["BOX_CPU_POLICY"] = "normal";
    replace["BOX_CPU_WEIGHT"] = "1.01";

    replace["BOX_MEMORY_GUARANTEE"] = ToString(1 << 25);
    replace["BOX_MEMORY_LIMIT"] = ToString(1 << 26);
    replace["BOX_ANON_LIMIT"] = ToString(1 << 27);
    replace["BOX_RECHARGE_ON_PGFAULT"] = "false";

    replace["BOX_THREAD_LIMIT"] = "1001";
    replace["BOX_CAPABILITIES_AMBIENT"] = "NET_BIND_SERVICE";

    replace["BOX_IO_LIMIT"] = "/tmp r: 20000";
    replace["BOX_IO_OPS_LIMIT"] = "/tmp r: 20001";
    replace["BOX_IO_POLICY"] = "normal";
    replace["BOX_IO_WEIGHT"] = "1.02";

    replace["BOX_ENABLE_PORTO"] = "";

    replace["BOX_CGROUP_FS_MOUNT_TYPE"] = "";

    replace["YT_VOLUME_PATH"] = PathHolder_->GetBoxRootfsPath(BoxId_) + "/yt";
    replace["YT_VOLUME_STORAGE"] = "/yt";
    replace["YT_ENABLED"] = "";

    replace["BASESEARCH_VOLUME_PATH"] = PathHolder_->GetBoxRootfsPath(BoxId_) + "/basesearch";
    replace["BASESEARCH_VOLUME_STORAGE"] = "/basesearch";
    replace["BASESEARCH_ENABLED"] = "";

    replace["SKYNET_VOLUME_PATH"] = PathHolder_->GetBoxRootfsPath(BoxId_) + "/place/berkanavt/supervisor";
    replace["SKYNET_VOLUME_STORAGE"] = "/place/berkanavt/supervisor";
    replace["SKYNET_ENABLED"] = "";

    replace["NETWORK_DEVICE"] = "";
    replace["BOX_IP6_ADDRESS"] = "";
    replace["BOX_RESOLV_CONF"] = "default";

    replace["BOX_HOSTNAME"] = "";
    replace["ROOTFS_VOLUME_PATH"] = PathHolder_->GetBoxRootfsPath(BoxId_);
    replace["ROOTFS_VOLUME_STORAGE"] = PathHolder_->GetBoxRootfsPersistentStorage(BoxId_);
    replace["ROOTFS_VOLUME_PLACE"] = "";
    replace["ROOTFS_QUOTA_BYTES"] = ToString(1 << 20);
    replace["ROOTFS_READ_ONLY"] = "";

    replace["MOUNT_VOLUME_PATH_LIST"] = PathHolder_->GetVolumePath(MountVolumeId_) + ';';
    replace["MOUNT_VOLUME_LINK_PATH_LIST"] = PathHolder_->GetBoxRootfsPath(BoxId_) + MOUNT_POINT + ';';
    replace["MOUNT_VOLUME_RO_MODE_LIST"] = "false;";
    replace["MOUNT_VOLUME_TREE_HASH_LIST"] = CORRECT_VOLUME_HASH + ";";
    replace["NON_PERSISTENT_MOUNT_VOLUME_ID_LIST"] = "";
    replace["NON_PERSISTENT_MOUNT_VOLUME_PATH_LIST"] = "";

    replace["RBIND_VOLUME_PATH_LIST"] = PathHolder_->GetBoxRootfsPath(BoxId_) + RBIND_VOLUME_MOUNT_PATH + ';';
    replace["RBIND_VOLUME_STORAGE_LIST"] = PathHolder_->GetRbindVolumeStorage(RbindVolumeRef_) + ';';
    replace["RBIND_VOLUME_RO_MODE_LIST"] = "false;";

    replace["LAYER_NAME_LIST"] = PathHolder_->GetLayerNameFromHash(LayerDownloadHashPrefix_) + ';';
    replace["LAYER_DOWNLOAD_HASH_LIST"] = LayerDownloadHashPrefix_ + ";";

    replace["STATIC_RESOURCE_PATHS"] = TBehavior3EditorJsonReader::EscapeCharactersForMemSequenceGenerator({"my_static_resource"});
    replace["STATIC_RESOURCE_ORIGINAL_PATHS"] = TBehavior3EditorJsonReader::EscapeCharactersForMemSequenceGenerator({PathHolder_->GetFinalStaticResourcePathFromHash(StaticResourceDownloadHashPrefix_, "")});

    replace["INIT_NUM_LIST"] = "";
    replace["INIT_CONTAINER_LIST"] = "";
    replace["INIT_CONTAINER_PREVIOUS_LIST"] = "";
    replace["INIT_ENVIRONMENT_LIST"] = "";
    replace["INIT_SECRET_ENVIRONMENT_LIST"] = "";
    replace["INIT_CMD_LIST"] = "";
    replace["INIT_CWD_LIST"] = "";

    replace["INIT_CPU_GUARANTEE_LIST"] = "";
    replace["INIT_CPU_LIMIT_LIST"] = "";
    replace["INIT_CPU_POLICY_LIST"] = "";
    replace["INIT_CPU_WEIGHT_LIST"] = "";
    replace["INIT_MEMORY_GUARANTEE_LIST"] = "";
    replace["INIT_MEMORY_LIMIT_LIST"] = "";
    replace["INIT_ANON_LIMIT_LIST"] = "";
    replace["INIT_RECHARGE_ON_PGFAULT_LIST"] = "";
    replace["INIT_THREAD_LIMIT_LIST"] = "";
    replace["INIT_ULIMIT_LIST"] = "";
    replace["INIT_CORE_COMMAND_LIST"] = "";
    replace["INIT_USER_LIST"] = "";
    replace["INIT_GROUP_LIST"] = "";
    replace["INIT_AGING_TIME_LIST"] = "";
    replace["INIT_IO_LIMIT_LIST"] = "";
    replace["INIT_IO_OPS_LIMIT_LIST"] = "";
    replace["INIT_IO_POLICY_LIST"] = "";
    replace["INIT_IO_WEIGHT_LIST"] = "";

    replace["INIT_INITIAL_DELAY_LIST"] = "";
    replace["INIT_RESTART_PERIOD_SCALE_LIST"] = "";
    replace["INIT_RESTART_PERIOD_BACKOFF_LIST"] = "";
    replace["INIT_MAX_RESTART_PERIOD_LIST"] = "";
    replace["INIT_MIN_RESTART_PERIOD_LIST"] = "";
    replace["INIT_MAX_EXECUTION_TIME_LIST"] = "";

    replace["INIT_STDOUT_LOG_FILE_FULL_PATH_TO_CREATE_LIST"] = "";
    replace["INIT_STDERR_LOG_FILE_FULL_PATH_TO_CREATE_LIST"] = "";
    replace["INIT_STDOUT_LOG_PATH_LIST"] = "";
    replace["INIT_STDERR_LOG_PATH_LIST"] = "";
    replace["INIT_STDOUT_AND_STDERR_FILE_SIZE_LIMIT_LIST"] = "";

    replace["BOX_ENVIRONMENT"] = "";
    replace["BOX_SECRET_ENVIRONMENT"] = "";

    replace["TREE_HASH"] = "tree_hash";

    return replace;
}

void ITestBoxCanon::PrepareLayer(const TString& suffix, const TString& data, const TString& place) {
    TStringBuilder commandBuilder;
    commandBuilder << "bash -c \"echo \\\"" << data <<  "\\\" > tmp.txt; "
                   << "mkdir -p " << PathHolder_->GetLayersDirectory(place) + "/" + LayerDownloadHashPrefix_ + suffix << "/downloaded_result; "
                   << "tar -czvf " << PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_ + suffix, place) << " tmp.txt\"";

    TShellCommand shellCommand(commandBuilder);
    shellCommand.Run();
    shellCommand.Wait();
    UNIT_ASSERT_EQUAL_C(TShellCommand::ECommandStatus::SHELL_FINISHED, shellCommand.GetStatus(), shellCommand.GetError());

    TString layerName = PathHolder_->GetLayerNameFromHash(LayerDownloadHashPrefix_ + suffix);
    SafePorto_->RemoveLayer(layerName, place);
    SafePorto_->ImportLayer(layerName, PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_ + suffix, place), false, place, "").Success();
    SafePorto_->SetLayerPrivate(":" + LayerDownloadHashPrefix_ + suffix, layerName, place).Success();
    LayerStatusRepository_->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(LayerIdPrefix_ + suffix, LayerDownloadHashPrefix_ + suffix));
    LayerStatusRepository_->UpdateObjectState(LayerDownloadHashPrefix_ + suffix, API::ELayerState_READY);
}

void ITestBoxCanon::PrepareLayerWithFolders(const TString& suffix, const TVector<TString>& folderNames, const TString& place) {
    TStringBuilder commandBuilder;
    commandBuilder << "bash -c \" ";
    for (auto folderName: folderNames) {
        commandBuilder << "mkdir -p " << folderName <<  "; ";
    }

    commandBuilder << "mkdir -p " << PathHolder_->GetLayersDirectory(place) + "/" + LayerDownloadHashPrefix_ + suffix << "/downloaded_result; "
                   << "tar -czvf " << PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_ + suffix, place);

    for (auto folderName: folderNames) {
        commandBuilder << " " << folderName;
    }

    commandBuilder << ";\"";

    TShellCommand shellCommand(commandBuilder);
    shellCommand.Run();
    shellCommand.Wait();
    UNIT_ASSERT_EQUAL_C(TShellCommand::ECommandStatus::SHELL_FINISHED, shellCommand.GetStatus(), shellCommand.GetError());

    TString layerName = PathHolder_->GetLayerNameFromHash(LayerDownloadHashPrefix_ + suffix);
    SafePorto_->RemoveLayer(layerName, place);
    SafePorto_->ImportLayer(layerName, PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_ + suffix, place), false, place, "").Success();
    SafePorto_->SetLayerPrivate(":" + LayerDownloadHashPrefix_ + suffix, layerName, place).Success();
    LayerStatusRepository_->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(LayerIdPrefix_ + suffix, LayerDownloadHashPrefix_ + suffix));
    LayerStatusRepository_->UpdateObjectState(LayerDownloadHashPrefix_ + suffix, API::ELayerState_READY);
}

void ITestBoxCanon::PrepareRootfsLayer(const TString& place) {
    TStringBuilder commandBuilder;
    commandBuilder << "bash -c \" "
                   << "mkdir -p " << PathHolder_->GetLayersDirectory(place) + "/" + LayerDownloadHashPrefix_ << "/downloaded_result; "
                   << "cp " << RealPath(GetWorkPath()) << "/layer.tar.xz " << PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_, place) << ";\"";

    TShellCommand shellCommand(commandBuilder);
    shellCommand.Run();
    shellCommand.Wait();
    UNIT_ASSERT_EQUAL_C(TShellCommand::ECommandStatus::SHELL_FINISHED, shellCommand.GetStatus(), shellCommand.GetError());

    TString layerName = PathHolder_->GetLayerNameFromHash(LayerDownloadHashPrefix_);
    SafePorto_->RemoveLayer(layerName, place);
    SafePorto_->ImportLayer(layerName, PathHolder_->GetFinalLayerPathFromHash(LayerDownloadHashPrefix_, place), false, place, "").Success();
    SafePorto_->SetLayerPrivate(":" + LayerDownloadHashPrefix_, layerName, place);

    LayerStatusRepository_->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(LayerIdPrefix_, LayerDownloadHashPrefix_));
    LayerStatusRepository_->UpdateObjectState(LayerDownloadHashPrefix_, API::ELayerState_READY);
}

void ITestBoxCanon::PrepareStaticResource(ui64 checkPeriodMs, const TString& place) {
    TStringBuilder commandBuilder;
    commandBuilder << "bash -c \" "
                   << "mkdir -p " << PathHolder_->GetFinalStaticResourcePathFromHash(StaticResourceDownloadHashPrefix_, place) << ";\"";

    TShellCommand shellCommand(commandBuilder);
    shellCommand.Run();
    shellCommand.Wait();
    UNIT_ASSERT_EQUAL_C(TShellCommand::ECommandStatus::SHELL_FINISHED, shellCommand.GetStatus(), shellCommand.GetError());

    StaticResourceStatusRepository_->AddObject(
        TStaticResourceMeta(
            StaticResourceIdPrefix_
            , 0
            , 0
            , StaticResourceDownloadHashPrefix_
            , checkPeriodMs
        )
    );
    StaticResourceStatusRepository_->UpdateObjectState(StaticResourceDownloadHashPrefix_, API::EStaticResourceState_READY);
}

void ITestBoxCanon::PrepareVolume(const TString suffix, const TString hash) {
    VolumeStatusRepository_->AddObject(NObjectMetaTestLib::CreateVolumeMetaSimple(MountVolumeId_ + suffix));
    const TString volumePath = PathHolder_->GetVolumePath(MountVolumeId_ + suffix);
    NFs::MakeDirectoryRecursive(volumePath);
    SafePorto_->CreateVolume(volumePath, PathHolder_->GetVolumePersistentStorage(MountVolumeId_ + suffix), "", {}, 0, hash, EPortoVolumeBackend::Auto, {""}, {}, false).Success();
}

void ITestBoxCanon::PrepareRbindVolumeStorage(const TString suffix) {
    const TString rbindVolumeStorage = PathHolder_->GetRbindVolumeStorage(RbindVolumeRef_ + suffix);
    NFs::MakeDirectoryRecursive(rbindVolumeStorage);
}

void ITestBoxCanon::RemoveStorageAndLayer() {
    {
        const TString volumeName = PathHolder_->GetBoxRootfsPath(BoxId_);
        const TString volumePrefix = PathHolder_->GetVolumePath(MountVolumeId_);
        auto volumeList = SafePorto_->ListVolumes().Success();
        if (!volumeList.empty()) {
            for (auto volume : volumeList) {
                if (volume.path() == volumeName || volume.path().StartsWith(volumePrefix)) {
                    auto result = SafePorto_->UnlinkVolume(volume.path());
                    if (!result) {
                        Cerr << ToString(result.Error().Message) << Endl;
                    }
                }
            }
        }
    }
    {
        auto list = SafePorto_->ListStorages("", PersistentStoragePrefix_ + "*").Success();
        for (const auto& storage : list) {
            auto result = SafePorto_->RemoveStorage(storage.name(), "");
            if (!result) {
                Cerr << ToString(result.Error().Message) << Endl;
            }
        }
    }
    {
        auto list = SafePorto_->ListLayers("", LayerPrefix_+ "*").Success();
        for (const auto& layer : list) {
            auto result = SafePorto_->RemoveLayer(layer.name(), "");
            if (!result) {
                Cerr << ToString(result.Error().Message) << Endl;
            }
        }
    }
}

void ITestBoxCanon::PrepareBox(ui32 initSize) {
    BoxStatusRepository_->AddObject(
        TBoxMeta(
            BoxId_
            , 0
            , 0
            , {}
            , {}
            , {}
            , ""
            , NObjectMetaTestLib::GenerateInitContainerNames(initSize)
            , ""
        )
    );
}

const TString ITestBoxCanon::MOUNT_POINT = "/mounted_data";
const TString ITestBoxCanon::CORRECT_VOLUME_HASH = "volume_tree_hash";

const TString ITestBoxCanon::RBIND_VOLUME_MOUNT_PATH = "/rbind_volume_data";

} // namespace NInfra::NPodAgent::NTreeTest
