#pragma once

#include <infra/pod_agent/libs/behaviour/trees/base/test/test_canon.h>

namespace NInfra::NPodAgent::NTreeTest {

class ITestBoxCanon: public ITestBehaviourTreeCanon {
public:
    ITestBoxCanon(const TString &testName, const TString &testSuiteName)
        : ITestBehaviourTreeCanon(testName, testSuiteName, "BoxTree")
        , LayerIdPrefix_("MyLayerId")
        , LayerDownloadHashPrefix_("MyLayerDownloadHash")
        , StaticResourceIdPrefix_("MyStaticResourceId")
        , StaticResourceDownloadHashPrefix_("MyStaticResourceDownloadHash")
        , BoxId_("MyBoxId")
        , MountVolumeId_("MyMountVolumeId")
        , RbindVolumeRef_("MyRbindVolumeRef")
    {
    }

    virtual ~ITestBoxCanon() {
        RemoveStorageAndLayer();
    }

protected:
    virtual TMap<TString, TString> GetReplace() const override final;

    virtual void SetupTest() override {
        PrepareBox(GetBoxInitSize());
    }

    virtual ui32 GetBoxInitSize() const {
        return 0;
    }

    void PrepareLayer(const TString& suffix, const TString& data, const TString& place = "");

    void PrepareLayerWithFolders(const TString& suffix, const TVector<TString>& folderNames, const TString& place = "");

    void PrepareRootfsLayer(const TString& place = "");

    void PrepareStaticResource(ui64 checkPeriodMs = 100, const TString& place = "");

    void PrepareVolume(const TString suffix = "", const TString hash = ITestBoxCanon::CORRECT_VOLUME_HASH);

    void PrepareRbindVolumeStorage(const TString suffix = "");

private:
    void RemoveStorageAndLayer();

    void PrepareBox(ui32 initSize = 0);

protected:
    static const TString MOUNT_POINT;
    static const TString CORRECT_VOLUME_HASH;

    static const TString RBIND_VOLUME_MOUNT_PATH;

    const TString LayerIdPrefix_;
    const TString LayerDownloadHashPrefix_;
    const TString StaticResourceIdPrefix_;
    const TString StaticResourceDownloadHashPrefix_;
    const TString BoxId_;
    const TString MountVolumeId_;
    const TString RbindVolumeRef_;
};

} // namespace NInfra::NPodAgent::NTreeTest
