#include "tree_workload_stop_test_canon.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTreeTest {

TMap<TString, TString> ITestTreeWorkloadStopCanon::GetReplace() const {
    TMap<TString, TString> replace;

    replace["WORKLOAD_ID"] = WorkloadId_;
    replace["START_CONTAINER"] = PathHolder_->GetWorkloadContainerWithName(BoxId_, WorkloadId_, "start");
    replace["WORKLOAD_ULIMIT"] = "";
    replace["WORKLOAD_CAPABILITIES_AMBIENT"] = "NET_BIND_SERVICE";

    replace["STOP_HOOK_TYPE"] = "container";
    replace["STOP_CONTAINER"] = PathHolder_->GetWorkloadContainerWithName(BoxId_, WorkloadId_, "stop");
    replace["STOP_ENVIRONMENT"] = "";
    replace["STOP_SECRET_ENVIRONMENT"] = "";
    replace["STOP_CMD"] = "bash -c \"echo stop; sleep 5000\"";
    replace["STOP_CWD"] = "";
    replace["STOP_CPU_GUARANTEE"] = "1c";
    replace["STOP_CPU_LIMIT"] = "1c";
    replace["STOP_CPU_POLICY"] = "normal";
    replace["STOP_CPU_WEIGHT"] = "1.01";
    replace["STOP_MEMORY_GUARANTEE"] = ToString(1 << 25);
    replace["STOP_MEMORY_LIMIT"] = ToString(1 << 25);
    replace["STOP_ANON_LIMIT"] = ToString(1 << 25);
    replace["STOP_RECHARGE_ON_PGFAULT"] = "false";
    replace["STOP_THREAD_LIMIT"] = "1001";
    replace["STOP_CORE_COMMAND"] = "";
    replace["STOP_USER"] = "";
    replace["STOP_GROUP"] = "";
    replace["STOP_AGING_TIME"] = ToString(1 << 16);
    replace["STOP_MIN_RESTART_PERIOD"] = "60000";
    replace["STOP_MAX_RESTART_PERIOD"] = "60000";
    replace["STOP_RESTART_PERIOD_BACKOFF"] = "1";
    replace["STOP_RESTART_PERIOD_SCALE"] = "0";
    replace["STOP_MAX_EXECUTION_TIME"] = "60000";
    replace["STOP_INITIAL_DELAY"] = "0";
    replace["STOP_MAX_TRIES"] = "1000";
    replace["STOP_STDOUT_LOG_FILE_FULL_PATH_TO_CREATE"] = "";
    replace["STOP_STDERR_LOG_FILE_FULL_PATH_TO_CREATE"] = "";
    replace["STOP_STDOUT_LOG_PATH"] = "";
    replace["STOP_STDERR_LOG_PATH"] = "";
    replace["STOP_STDOUT_AND_STDERR_FILE_SIZE_LIMIT"] = "";
    replace["STOP_IO_LIMIT"] = "/tmp r: 20000";
    replace["STOP_IO_OPS_LIMIT"] = "/tmp r: 20001";
    replace["STOP_IO_POLICY"] = "normal";
    replace["STOP_IO_WEIGHT"] = "1.02";

    replace["BOX_CONTAINER"] = PathHolder_->GetBoxContainer(BoxId_);
    replace["TREE_HASH"] = "tree_hash";

    replace["HTTP_STOP_PATH"] = "/mock_path";
    replace["HTTP_STOP_PORT"] = "";
    replace["HTTP_STOP_RESPONSE"] = "";
    replace["HTTP_STOP_ANY_RESPONSE"] = "true";
    replace["HTTP_STOP_MAX_EXECUTION_TIME"] = "500";
    replace["HTTP_STOP_INITIAL_DELAY"] = "0";
    replace["HTTP_STOP_RESTART_PERIOD_SCALE"] = "1";
    replace["HTTP_STOP_RESTART_PERIOD_BACKOFF"] = "60000";
    replace["HTTP_STOP_MAX_RESTART_PERIOD"] = "60000";
    replace["HTTP_STOP_MIN_RESTART_PERIOD"] = "60000";

    replace["UNIX_SIGNAL_STOP_SIGNAL"] = ToString(SIGTERM);
    replace["UNIX_SIGNAL_STOP_INITIAL_DELAY"] = "0";
    replace["UNIX_SIGNAL_STOP_RESTART_PERIOD_SCALE"] = "1";
    replace["UNIX_SIGNAL_STOP_RESTART_PERIOD_BACKOFF"] = "60000";
    replace["UNIX_SIGNAL_STOP_MAX_RESTART_PERIOD"] = "60000";
    replace["UNIX_SIGNAL_STOP_MIN_RESTART_PERIOD"] = "60000";

    return replace;
}

void ITestTreeWorkloadStopCanon::PrepareWorkloadStartContainer() {
    const TPortoContainerName workloadStartName = GetFullWorkloadContainerName("start");

    SafePorto_->Create(workloadStartName).Success();
    SafePorto_->SetProperty(workloadStartName, EPortoContainerProperty::Command, "bash -c \"echo start; sleep 1000\"").Success();
    SafePorto_->SetProperty(workloadStartName, EPortoContainerProperty::Private, PackContainerPrivate({CP_EMPTY, "tree_hash"}));
    SafePorto_->Start(workloadStartName).Success();
    UNIT_ASSERT_EQUAL_C(ToString(EPortoContainerState::Running), SafePorto_->GetProperty(workloadStartName, EPortoContainerProperty::State).Success(), "failed to start 'start' container");
}

} // namespace NInfra::NPodAgent::NTreeTest
