#include "client.h"

#include <contrib/libs/grpc/include/grpc++/security/credentials.h>

namespace NInfra::NPodAgent {

TClient::TClient(TStringBuf address, const TDuration& timeout /* = 1 second*/)
    : Channel_(grpc::CreateChannel(static_cast<std::string>(address), grpc::InsecureChannelCredentials()))
    , Stub_(TPodAgentService::NewStub(Channel_))
    , Timeout_(timeout)
{
}

void TClient::Config(TRequestPtr<TReqConfig> request, TReplyPtr<TRspConfig> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::Config);
}

void TClient::Shutdown(TRequestPtr<TReqShutdown> request, TReplyPtr<TRspShutdown> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::Shutdown);
}

void TClient::SetLogLevel(TRequestPtr<TReqSetLogLevel> request, TReplyPtr<TRspSetLogLevel> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::SetLogLevel);
}

void TClient::UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest> request, TReplyPtr<API::TPodAgentStatus> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::UpdatePodAgentRequest);
}

void TClient::GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus> request, TReplyPtr<API::TPodAgentStatus> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::GetPodAgentStatus);
}

void TClient::Ping(TRequestPtr<TReqPing> request, TReplyPtr<TRspPing> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::Ping);
}

void TClient::Sensors(TRequestPtr<TReqSensors> request, TReplyPtr<TRspSensors> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::Sensors);
}

void TClient::UserSensors(TRequestPtr<TReqSensors> request, TReplyPtr<TRspSensors> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::UserSensors);
}

void TClient::Version(TRequestPtr<TReqVersion> request, TReplyPtr<TRspVersion> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::Version);
}

void TClient::ReopenLog(TRequestPtr<TReqReopenLog> request, TReplyPtr<TRspReopenLog> reply) {
    GrpcRequest(request, reply, &TPodAgentService::Stub::ReopenLog);
}

} // namespace NInfra::NPodAgent
