#pragma once

#include <infra/pod_agent/libs/service_iface/protos/service.grpc.pb.h>

#include <infra/pod_agent/libs/service_iface/api.h>

#include <contrib/libs/grpc/include/grpc++/channel.h>
#include <contrib/libs/grpc/include/grpc++/create_channel.h>

#include <util/datetime/base.h>
#include <util/generic/bt_exception.h>
#include <util/generic/hash.h>

namespace NInfra::NPodAgent {

class TClient: public IApi {
public:
    TClient(TStringBuf, const TDuration& timeout = TDuration::Seconds(1));

    void Config(TRequestPtr<TReqConfig> request, TReplyPtr<TRspConfig> reply) override;

    void Shutdown(TRequestPtr<TReqShutdown> request, TReplyPtr<TRspShutdown> reply) override;

    void SetLogLevel(TRequestPtr<TReqSetLogLevel> request, TReplyPtr<TRspSetLogLevel> reply) override;

    void UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest> request, TReplyPtr<API::TPodAgentStatus> reply) override;

    void GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus>, TReplyPtr<API::TPodAgentStatus> reply) override;

    void Ping(TRequestPtr<TReqPing> request, TReplyPtr<TRspPing> reply)  override;

    void Sensors(TRequestPtr<TReqSensors> request, TReplyPtr<TRspSensors> reply)  override;

    void UserSensors(TRequestPtr<TReqSensors> request, TReplyPtr<TRspSensors> reply)  override;

    void Version(TRequestPtr<TReqVersion> request, TReplyPtr<TRspVersion> reply)  override;

    void ReopenLog(TRequestPtr<TReqReopenLog> request, TReplyPtr<TRspReopenLog> reply)  override;

private:
    template <typename TRequest, typename TReply, typename TCallback>
    void GrpcRequest(TRequestPtr<TRequest> request, TReplyPtr<TReply> reply, TCallback callback) {
        TReply result;
        grpc::ClientContext context;

        context.set_deadline(std::chrono::system_clock::now() + std::chrono::milliseconds(Timeout_.MilliSeconds()));

        grpc::Status status = ((*Stub_).*callback)(&context, request->Get(), &result);

        Y_ENSURE_EX(status.ok(), TWithBackTrace<yexception>() << status.error_message());
        reply->Set(result);
    }

private:
    std::shared_ptr<grpc::Channel> Channel_;
    std::shared_ptr<TPodAgentService::Stub> Stub_;

    const TDuration Timeout_;
};

} // namespace NInfra::NPodAgent
