#include "client.h"
#include "main.h"

#include <infra/pod_agent/libs/router_api/router_api.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/datetime/base.h>
#include <util/stream/file.h>

namespace NInfra::NPodAgent {

int RunClient(int argc, const char* argv[]) {
    NLastGetopt::TOpts opts;

    TString postData;
    TString fileName;

    opts.SetFreeArgsNum(2);
    opts.SetFreeArgTitle(0, "<address> <command>", "server address and function name");

    opts
        .AddLongOption("request-data", "request data")
        .Optional()
        .RequiredArgument()
        .StoreResult(&postData);

    opts
        .AddLongOption("request-data-file", "file with request data")
        .Optional()
        .RequiredArgument()
        .StoreResult(&fileName);


    TDuration timeout;

    opts
        .AddLongOption('t', "timeout", "request timeout(e.g 10s, 15ms, 15.05s, 20us, or just 25 (s))")
        .Optional()
        .RequiredArgument()
        .StoreResult(&timeout)
        .DefaultValue("1s");

    NLastGetopt::TOptsParseResult parsedOpts(&opts, argc, argv);

    const TString address = parsedOpts.GetFreeArgs()[0];
    const TString command = parsedOpts.GetFreeArgs()[1];

    if (!fileName.empty()) {
        Y_ENSURE(postData.empty(), "You can't use both 'request-data' and 'request-data-file' parameters simultaneously");

        postData = TFileInput(fileName).ReadAll();
    }

    TClient client(address, timeout);
    auto router = CreateRouter(client, true /*withPrivateAPI*/);

    Cout << router->Handle(to_lower(command), postData, {}).Content << '\n';

    return EXIT_SUCCESS;
}

} // namespace NInfra::NPodAgent
