#include "test_service.h"

namespace NInfra::NPodAgent {

void TTestService::Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing>) {
    Actions_.insert("/ping");
}

void TTestService::Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown>) {
    Actions_.insert("/shutdown");
}

void TTestService::Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) {
    Actions_.insert("/sensors");
}

void TTestService::UserSensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) {
    Actions_.insert("/user_sensors");
}

void TTestService::Version(TRequestPtr<TReqVersion>, TReplyPtr<TRspVersion>) {
    Actions_.insert("/version");
}

void TTestService::Config(TRequestPtr<TReqConfig>, TReplyPtr<TRspConfig>) {
    Actions_.insert("/config");
}

void TTestService::ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) {
    Actions_.insert("/reopen_log");
}

void TTestService::SetLogLevel(TRequestPtr<TReqSetLogLevel> request, TReplyPtr<TRspSetLogLevel>) {
    LogLevel_ = request->Get().GetLevel();
}

void TTestService::UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest>, TReplyPtr<API::TPodAgentStatus>) {
    Actions_.insert("/update_pod_request");
}

void TTestService::GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus>, TReplyPtr<API::TPodAgentStatus>) {
    Actions_.insert("/get_pod_agent_status");
}

bool TTestService::WasAction(const TString& action) const {
    return Actions_.contains(action);
}

const TString& TTestService::LogLevel() const {
    return LogLevel_;
}

} // namespace NInfra::NPodAgent
