#pragma once

#include <infra/pod_agent/libs/service_iface/service.h>

#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class TTestService : public IService {
public:
    void Start() override {
    }

    void Wait() override {
    }

    void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing>) override;

    void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown>) override;

    void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) override;

    void UserSensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) override;

    void Version(TRequestPtr<TReqVersion>, TReplyPtr<TRspVersion>) override;

    void Config(TRequestPtr<TReqConfig>, TReplyPtr<TRspConfig>) override;

    void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) override;

    void SetLogLevel(TRequestPtr<TReqSetLogLevel> request, TReplyPtr<TRspSetLogLevel>) override;

    void UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest>, TReplyPtr<API::TPodAgentStatus>) override;

    void GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus>, TReplyPtr<API::TPodAgentStatus>) override;

    bool WasAction(const TString& action) const;

    const TString& LogLevel() const;

private:
    THashSet<TString> Actions_;
    TString LogLevel_ = "Unknown";
};

} // namespace NInfra::NPodAgent
