#pragma once

#include <infra/pod_agent/libs/service_iface/protos/pod_agent_api.pb.h>

#include <google/protobuf/timestamp.pb.h>
#include <util/datetime/base.h>

namespace NInfra::NPodAgent {

ui64 TimestampToMicros(const google::protobuf::Timestamp& timestamp);

TMaybe<std::pair<TString, TString>> ExtractSaltAndMd5FromSecret(const TString& secret);

bool GetBooleanDeployLabel(const API::TPodAgentRequest& podAgentRequest, const TString& labelKey);

} // namespace NInfra::NPodAgent
