#include "common.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/maybe.h>

namespace NInfra::NPodAgent::NCommonTest {

Y_UNIT_TEST_SUITE(CommonSuite) {

Y_UNIT_TEST(TestExtractSaltAndMd5) {
    TString secret = "<secret salt= 1111111 md5=qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq>";
    auto result = ExtractSaltAndMd5FromSecret(secret);
    UNIT_ASSERT(result);
    UNIT_ASSERT_EQUAL_C(result.Get()->first, " 1111111", "'" + result.Get()->first + "'");
    UNIT_ASSERT_EQUAL_C(result.Get()->second, "qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq", result.Get()->second);
}

Y_UNIT_TEST(TestExtractSaltAndMd5Error) {
    TVector<TString> secrets = {
        "value",
        "<secret salt=11111111>",
        "<secret md5=qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq>",
        "<secret salt=11111111 md5=qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq"
    };
    for (const auto& secret: secrets) {
        auto result = ExtractSaltAndMd5FromSecret(secret);
        UNIT_ASSERT(!result);
    }
}

Y_UNIT_TEST(TestGetBooleanDeployLabelSuccess) {
    API::TPodAgentRequest request;
    auto* attr = request.mutable_pod_dynamic_attributes()->mutable_labels()->mutable_attributes()->Add();
    attr->set_key("deploy");
    attr->set_value("{use_env_secret=%true;}");
    UNIT_ASSERT(GetBooleanDeployLabel(request, "use_env_secret"));

    attr->set_value("{use_env_secret=%false;}");
    UNIT_ASSERT(!GetBooleanDeployLabel(request, "use_env_secret"));
}

Y_UNIT_TEST(TestGetBooleanDeployLabelWhenUnexpectedFormat) {
    API::TPodAgentRequest request;
    auto* attr = request.mutable_pod_dynamic_attributes()->mutable_labels()->mutable_attributes()->Add();
    attr->set_key("use_env_secret");
    attr->set_value("%true");
    UNIT_ASSERT(!GetBooleanDeployLabel(request, "use_env_secret"));

    attr->set_key("deploy");
    attr->set_value("{use_env_secret=\"true\";}");
    UNIT_ASSERT(!GetBooleanDeployLabel(request, "use_env_secret"));

    attr->set_key("deploy");
    attr->set_value("{some_key=%true;}");
    UNIT_ASSERT(!GetBooleanDeployLabel(request, "use_env_secret"));
}

}

}